/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.correction;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.correction.RenameInFileQuickAssistProposal;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.w3c.dom.Node;

public class SurroundWithNewElementQuickAssistProposal
extends RenameInFileQuickAssistProposal {
    private static final String ELEMENT_NAME = "element";

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        try {
            int startTagOffset = offset;
            int endTagOffset = offset + viewer.getSelectedRange().y;
            if (startTagOffset == endTagOffset) {
                IDOMNode cursorNode = (IDOMNode)ContentAssistUtils.getNodeAt((ITextViewer)viewer, (int)offset);
                if (cursorNode.getNodeType() == 3 && cursorNode.getNodeValue().trim().length() == 0) {
                    cursorNode = (IDOMNode)cursorNode.getParentNode();
                }
                startTagOffset = cursorNode.getStartOffset();
                endTagOffset = cursorNode.getEndOffset();
            }
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            multiTextEdit.addChild((TextEdit)new InsertEdit(startTagOffset, "<element>"));
            multiTextEdit.addChild((TextEdit)new InsertEdit(endTagOffset, "</element>"));
            multiTextEdit.apply(viewer.getDocument());
            Position start = new Position(startTagOffset);
            Position end = new Position(endTagOffset + "<element>".length());
            try {
                viewer.getDocument().addPosition(start);
                viewer.getDocument().addPosition(end);
                IDOMNode newElementNode = (IDOMNode)ContentAssistUtils.getNodeAt((ITextViewer)viewer, (int)startTagOffset);
                FormatProcessorXML formatProcessor = new FormatProcessorXML();
                formatProcessor.formatNode((Node)newElementNode);
                this.apply(viewer, trigger, stateMask, start, end, ELEMENT_NAME.length());
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                viewer.getDocument().removePosition(start);
                viewer.getDocument().removePosition(end);
                throw throwable;
            }
            {
                Object var12_16 = null;
                viewer.getDocument().removePosition(start);
                viewer.getDocument().removePosition(end);
                return;
            }
        }
        catch (MalformedTreeException e) {
            Logger.log(1, e.getMessage());
            return;
        }
        catch (BadLocationException e) {
            Logger.log(1, e.getMessage());
        }
    }

    private void apply(ITextViewer viewer, char trigger, int stateMask, Position start, Position end, int length) {
        IDocument document = viewer.getDocument();
        LinkedPositionGroup group = new LinkedPositionGroup();
        try {
            group.addPosition(new LinkedPosition(document, start.offset + 1, length, 0));
            group.addPosition(new LinkedPosition(document, end.offset + 2, length, 1));
            if (viewer instanceof ITextViewerExtension) {
                ((ITextViewerExtension)viewer).setRedraw(true);
            }
            LinkedModeModel linkedModeModel = new LinkedModeModel();
            linkedModeModel.addGroup(group);
            linkedModeModel.forceInstall();
            EditorLinkedModeUI ui = new EditorLinkedModeUI(linkedModeModel, viewer);
            ui.setExitPosition(viewer, start.offset, 0, -1);
            ui.enter();
            this.fSelectedRegion = ui.getSelectedRegion();
        }
        catch (BadLocationException e) {
            Logger.log(1, e.getMessage());
        }
    }

    public String getAdditionalProposalInfo() {
        return XMLUIMessages.SurroundWithNewElementQuickAssistProposal_0;
    }

    public String getDisplayString() {
        return XMLUIMessages.SurroundWithNewElementQuickAssistProposal_1;
    }

    public Image getImage() {
        return XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/add_correction.gif");
    }
}

