/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;
import org.eclipse.wst.jsdt.internal.core.index.EntryResult;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchScope;

public abstract class InternalSearchPattern {
    IJavaScriptElement focus;
    int kind;
    boolean mustResolve = true;

    void acceptMatch(String relativePath, String containerPath, SearchPattern pattern, IndexQueryRequestor requestor, SearchParticipant participant, IJavaScriptSearchScope scope) {
        String documentPath;
        String documentPath2;
        JavaSearchScope javaSearchScope;
        AccessRuleSet access;
        if (scope instanceof JavaSearchScope ? (access = (javaSearchScope = (JavaSearchScope)scope).getAccessRuleSet(relativePath, containerPath)) != JavaSearchScope.NOT_ENCLOSED && !requestor.acceptIndexMatch(documentPath2 = this.documentPath(containerPath, relativePath), pattern, participant, access) : scope.encloses(documentPath = this.documentPath(containerPath, relativePath)) && !requestor.acceptIndexMatch(documentPath, pattern, participant, null)) {
            throw new OperationCanceledException();
        }
    }

    SearchPattern currentPattern() {
        return (SearchPattern)this;
    }

    String documentPath(String containerPath, String relativePath) {
        if (containerPath != null && relativePath != null) {
            Path container = new Path(containerPath);
            Path relative = new Path(relativePath);
            if (container.makeAbsolute().equals((Object)relative.makeAbsolute())) {
                return relativePath;
            }
        }
        String separator = Util.isArchiveFileName(containerPath) ? "|" : "/";
        StringBuffer buffer = new StringBuffer(containerPath.length() + separator.length() + relativePath.length());
        buffer.append(new Path(containerPath).toString());
        buffer.append(separator);
        buffer.append(new Path(relativePath).toString());
        return buffer.toString();
    }

    public void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaScriptSearchScope scope, IProgressMonitor monitor) throws IOException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            index.startQuery();
            SearchPattern pattern = this.currentPattern();
            EntryResult[] entries = pattern.queryIn(index);
            if (entries == null) {
                return;
            }
            SearchPattern decodedResult = pattern.getBlankPattern();
            String containerPath = index.containerPath;
            int i = 0;
            int l = entries.length;
            while (i < l) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                EntryResult entry = entries[i];
                decodedResult.decodeIndexKey(entry.getWord());
                if (pattern.matchesDecodedKey(decodedResult)) {
                    String[] names = entry.getDocumentNames(index);
                    int j = 0;
                    int n = names.length;
                    while (j < n) {
                        if (!scope.shouldExclude(containerPath, names[j])) {
                            this.acceptMatch(names[j], containerPath, decodedResult, requestor, participant, scope);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        finally {
            index.stopQuery();
        }
    }

    boolean isPolymorphicSearch() {
        return false;
    }

    EntryResult[] queryIn(Index index) throws IOException {
        SearchPattern pattern = (SearchPattern)this;
        return index.query(pattern.getIndexCategories(), pattern.getIndexKey(), pattern.getMatchRule());
    }
}

