/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.InferredAttribute;
import org.eclipse.wst.jsdt.core.infer.InferredMethod;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ImportReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Reference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.wst.jsdt.internal.core.search.matching.ConstructorLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.ConstructorPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.FieldLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.FieldPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.LocalVariableLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.LocalVariablePattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.wst.jsdt.internal.core.search.matching.MethodLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.MethodPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.OrLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.OrPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.PackageDeclarationLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.PackageDeclarationPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.PackageReferenceLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.PackageReferencePattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.SuperTypeReferenceLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.SuperTypeReferencePattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.TypeDeclarationLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.TypeReferenceLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.TypeReferencePattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.VariablePattern;

public abstract class PatternLocator
implements IIndexConstants {
    protected int matchMode;
    protected boolean isCaseSensitive;
    protected boolean isCamelCase;
    protected boolean isEquivalentMatch;
    protected boolean isErasureMatch;
    protected boolean mustResolve;
    protected boolean mayBeGeneric;
    SearchMatch match = null;
    public static final int IMPOSSIBLE_MATCH = 0;
    public static final int INACCURATE_MATCH = 1;
    public static final int POSSIBLE_MATCH = 2;
    public static final int ACCURATE_MATCH = 3;
    public static final int ERASURE_MATCH = 4;
    public static final int EXACT_FLAVOR = 16;
    public static final int PREFIX_FLAVOR = 32;
    public static final int PATTERN_FLAVOR = 64;
    public static final int REGEXP_FLAVOR = 128;
    public static final int CAMELCASE_FLAVOR = 256;
    public static final int SUPER_INVOCATION_FLAVOR = 512;
    public static final int SUB_INVOCATION_FLAVOR = 1024;
    public static final int OVERRIDDEN_METHOD_FLAVOR = 2048;
    public static final int MATCH_LEVEL_MASK = 15;
    public static final int FLAVORS_MASK = -16;
    public static final int COMPILATION_UNIT_CONTAINER = 1;
    public static final int CLASS_CONTAINER = 2;
    public static final int METHOD_CONTAINER = 4;
    public static final int FIELD_CONTAINER = 8;
    public static final int ALL_CONTAINER = 15;
    public static final int RAW_MASK = 48;
    public static final int RULE_MASK = 48;

    public static PatternLocator patternLocator(SearchPattern pattern) {
        switch (pattern.kind) {
            case 1: {
                return new PackageReferenceLocator((PackageReferencePattern)pattern);
            }
            case 2: {
                return new PackageDeclarationLocator((PackageDeclarationPattern)pattern);
            }
            case 4: {
                return new TypeReferenceLocator((TypeReferencePattern)pattern);
            }
            case 8: {
                return new TypeDeclarationLocator((TypeDeclarationPattern)pattern);
            }
            case 16: {
                return new SuperTypeReferenceLocator((SuperTypeReferencePattern)pattern);
            }
            case 32: {
                return new ConstructorLocator((ConstructorPattern)pattern);
            }
            case 64: {
                IField field;
                IJavaScriptElement element = ((FieldPattern)pattern).getJavaElement();
                if (element instanceof IField && (field = (IField)element).getDeclaringType() == null) {
                    return new LocalVariableLocator((VariablePattern)pattern);
                }
                return new FieldLocator((FieldPattern)pattern);
            }
            case 128: {
                return new MethodLocator((MethodPattern)pattern);
            }
            case 256: {
                return new OrLocator((OrPattern)pattern);
            }
            case 512: {
                return new LocalVariableLocator((LocalVariablePattern)pattern);
            }
        }
        return null;
    }

    public static char[] qualifiedPattern(char[] simpleNamePattern, char[] qualificationPattern) {
        if (simpleNamePattern == null) {
            if (qualificationPattern == null) {
                return null;
            }
            return CharOperation.concat(qualificationPattern, ONE_STAR, '.');
        }
        return qualificationPattern == null ? CharOperation.concat(ONE_STAR, simpleNamePattern) : CharOperation.concat(qualificationPattern, simpleNamePattern, '/');
    }

    public static char[] qualifiedSourceName(TypeBinding binding) {
        ReferenceBinding type;
        if (binding instanceof ReferenceBinding && (type = (ReferenceBinding)binding).isLocalType()) {
            return type.isMemberType() ? CharOperation.concat(PatternLocator.qualifiedSourceName(type.enclosingType()), type.sourceName(), '.') : CharOperation.concat(PatternLocator.qualifiedSourceName(type.enclosingType()), new char[]{'.', '1', '.'}, type.sourceName());
        }
        return binding != null ? binding.qualifiedSourceName() : null;
    }

    public PatternLocator(SearchPattern pattern) {
        int matchRule = pattern.getMatchRule();
        this.isCaseSensitive = (matchRule & 8) != 0;
        this.isCamelCase = (matchRule & 0x80) != 0;
        this.isErasureMatch = (matchRule & 0x10) != 0;
        this.isEquivalentMatch = (matchRule & 0x20) != 0;
        this.matchMode = matchRule & 7;
        this.mustResolve = pattern.mustResolve;
    }

    protected void clear() {
    }

    protected char[] getQualifiedPattern(char[] simpleNamePattern, char[] qualificationPattern) {
        if (simpleNamePattern == null) {
            if (qualificationPattern == null) {
                return null;
            }
            return CharOperation.concat(qualificationPattern, ONE_STAR, '.');
        }
        if (qualificationPattern == null) {
            return simpleNamePattern;
        }
        return CharOperation.concat(qualificationPattern, simpleNamePattern, '.');
    }

    protected char[] getQualifiedSourceName(TypeBinding binding) {
        TypeBinding type;
        TypeBinding typeBinding = type = binding instanceof ArrayBinding ? ((ArrayBinding)binding).leafComponentType : binding;
        if (type instanceof ReferenceBinding) {
            if (type.isLocalType()) {
                return CharOperation.concat(PatternLocator.qualifiedSourceName(type.enclosingType()), new char[]{'.', '1', '.'}, binding.sourceName());
            }
            if (type.isMemberType()) {
                return CharOperation.concat(PatternLocator.qualifiedSourceName(type.enclosingType()), binding.sourceName(), '.');
            }
        }
        return binding != null ? binding.qualifiedSourceName() : null;
    }

    protected TypeBinding getTypeNameBinding(int index) {
        return null;
    }

    public void initializePolymorphicSearch(MatchLocator locator) {
    }

    public int match(ASTNode node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(ConstructorDeclaration node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(Expression node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(FieldDeclaration node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(LocalDeclaration node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(MethodDeclaration node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(MessageSend node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(Reference node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(TypeDeclaration node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(TypeReference node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(InferredType inferredType, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(InferredMethod inferredMethod, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(InferredAttribute inferredAttribute, MatchingNodeSet nodeSet) {
        return 0;
    }

    protected int matchContainer() {
        return 15;
    }

    protected boolean matchesName(char[] pattern, char[] name) {
        if (pattern == null) {
            return true;
        }
        if (name == null) {
            return false;
        }
        return this.matchNameValue(pattern, name) != 0;
    }

    protected int matchNameValue(char[] pattern, char[] name) {
        boolean canBePrefix;
        if (pattern == null) {
            return 3;
        }
        if (name == null) {
            return 0;
        }
        if (name.length == 0) {
            if (pattern.length == 0) {
                return 3;
            }
            return 0;
        }
        if (pattern.length == 0) {
            return 0;
        }
        boolean matchFirstChar = !this.isCaseSensitive || pattern[0] == name[0];
        boolean sameLength = pattern.length == name.length;
        boolean bl = canBePrefix = name.length >= pattern.length;
        if (this.isCamelCase && matchFirstChar && CharOperation.camelCaseMatch(pattern, name)) {
            return 2;
        }
        switch (this.matchMode) {
            case 0: {
                if (!this.isCamelCase) {
                    if (!sameLength || !matchFirstChar || !CharOperation.equals(pattern, name, this.isCaseSensitive)) break;
                    return 18;
                }
            }
            case 1: {
                if (!canBePrefix || !matchFirstChar || !CharOperation.prefixEquals(pattern, name, this.isCaseSensitive)) break;
                return 2;
            }
            case 2: {
                if (!this.isCaseSensitive) {
                    pattern = CharOperation.toLowerCase(pattern);
                }
                if (!CharOperation.match(pattern, name, this.isCaseSensitive)) break;
                return 2;
            }
        }
        return 0;
    }

    protected boolean isAccurateNameMatch(char[] pattern, char[] sourceName) {
        if ((this.matchMode & 1) != 0 && CharOperation.prefixEquals(pattern, sourceName, this.isCaseSensitive)) {
            return true;
        }
        if (this.isCamelCase) {
            if ((!this.isCaseSensitive || pattern.length > 0 && sourceName.length > 0 && pattern[0] == sourceName[0]) && CharOperation.camelCaseMatch(pattern, sourceName)) {
                return true;
            }
            if (this.matchMode == 0) {
                return CharOperation.prefixEquals(pattern, sourceName, this.isCaseSensitive);
            }
        }
        return CharOperation.match(pattern, sourceName, this.isCaseSensitive);
    }

    protected boolean matchesTypeReference(char[] pattern, TypeReference type) {
        if (pattern == null) {
            return true;
        }
        if (type == null) {
            return true;
        }
        char[][] compoundName = type.getTypeName();
        char[] simpleName = compoundName[compoundName.length - 1];
        int dimensions = type.dimensions() * 2;
        if (dimensions > 0) {
            int length = simpleName.length;
            char[] result = new char[length + dimensions];
            System.arraycopy(simpleName, 0, result, 0, length);
            int i = length;
            int l = result.length;
            while (i < l) {
                result[i++] = 91;
                result[i++] = 93;
            }
            simpleName = result;
        }
        return this.matchesName(pattern, simpleName);
    }

    protected int matchLevel(ImportReference importRef) {
        return 0;
    }

    protected void matchLevelAndReportImportRef(ImportReference importRef, Binding binding, MatchLocator locator) throws CoreException {
        int level = this.resolveLevel(binding);
        if (level >= 1) {
            this.matchReportImportRef(importRef, binding, locator.createImportHandle(importRef), level == 3 ? 0 : 1, locator);
        }
    }

    protected void matchReportImportRef(ImportReference importRef, Binding binding, IJavaScriptElement element, int accuracy, MatchLocator locator) throws CoreException {
        if (locator.encloses(element)) {
            this.matchReportReference(importRef, element, null, accuracy, locator);
        }
    }

    protected void matchReportReference(ASTNode reference, IJavaScriptElement element, Binding elementBinding, int accuracy, MatchLocator locator) throws CoreException {
        this.match = null;
        int referenceType = this.referenceType();
        int offset = reference.sourceStart;
        switch (referenceType) {
            case 4: {
                this.match = locator.newPackageReferenceMatch(element, accuracy, offset, reference.sourceEnd - offset + 1, reference);
                break;
            }
            case 7: {
                this.match = locator.newTypeReferenceMatch(element, elementBinding, accuracy, offset, reference.sourceEnd - offset + 1, reference);
                break;
            }
            case 8: {
                this.match = locator.newFieldReferenceMatch(element, elementBinding, accuracy, offset, reference.sourceEnd - offset + 1, reference);
                break;
            }
            case 14: {
                this.match = locator.newLocalVariableReferenceMatch(element, accuracy, offset, reference.sourceEnd - offset + 1, reference);
            }
        }
        if (this.match != null) {
            locator.report(this.match);
        }
    }

    protected void matchReportReference(ASTNode reference, IJavaScriptElement element, IJavaScriptElement localElement, IJavaScriptElement[] otherElements, Binding elementBinding, int accuracy, MatchLocator locator) throws CoreException {
        this.matchReportReference(reference, element, elementBinding, accuracy, locator);
    }

    protected void matchReportReference(ASTNode reference, IJavaScriptElement element, Binding elementBinding, Scope scope, int accuracy, MatchLocator locator) throws CoreException {
        this.matchReportReference(reference, element, elementBinding, accuracy, locator);
    }

    public SearchMatch newDeclarationMatch(ASTNode reference, IJavaScriptElement element, Binding elementBinding, int accuracy, int length, MatchLocator locator) {
        AbstractMethodDeclaration method;
        int offset;
        int n = offset = reference != null ? reference.sourceStart : 0;
        if (reference instanceof AbstractMethodDeclaration && (method = (AbstractMethodDeclaration)reference).getName() == null && method.inferredMethod != null) {
            offset = method.inferredMethod.nameStart;
            if (length >= 0) {
                length = method.inferredMethod.name.length;
            }
        }
        return locator.newDeclarationMatch(element, elementBinding, accuracy, offset, length);
    }

    protected int referenceType() {
        return 0;
    }

    public int resolveLevel(ASTNode possibleMatchingNode) {
        return 0;
    }

    protected void updateMatch(TypeBinding[] argumentsBinding, MatchLocator locator, char[][] patternArguments, boolean hasTypeParameters) {
        if (locator.unitScope == null) {
            return;
        }
        int patternTypeArgsLength = patternArguments == null ? 0 : patternArguments.length;
        int typeArgumentsLength = argumentsBinding == null ? 0 : argumentsBinding.length;
        int matchRule = this.match.getRule();
        if (this.match.isRaw() && patternTypeArgsLength != 0) {
            matchRule &= 0xFFFFFFBF;
        }
        if (hasTypeParameters) {
            matchRule = 16;
        }
        if (patternTypeArgsLength == typeArgumentsLength) {
            if (!this.match.isRaw() && hasTypeParameters) {
                this.match.setRule(16);
                return;
            }
        } else {
            if (patternTypeArgsLength == 0) {
                if (!this.match.isRaw() || hasTypeParameters) {
                    this.match.setRule(matchRule & 0xFFFFFFBF);
                }
            } else if (typeArgumentsLength == 0) {
                this.match.setRule(matchRule & 0xFFFFFFBF);
            } else {
                this.match.setRule(0);
            }
            return;
        }
        if (argumentsBinding == null || patternArguments == null) {
            this.match.setRule(matchRule);
            return;
        }
        if (!hasTypeParameters && !this.match.isRaw() && (this.match.isEquivalent() || this.match.isExact())) {
            int i = 0;
            while (i < typeArgumentsLength) {
                TypeBinding argumentBinding = argumentsBinding[i];
                char[] patternTypeArgument = patternArguments[i];
                char patternWildcard = patternTypeArgument[0];
                char[] patternTypeName = patternTypeArgument;
                TypeBinding patternBinding = locator.getType(patternTypeArgument, patternTypeName = Signature.toCharArray(patternTypeName));
                if (patternBinding != null) {
                    if (argumentBinding != patternBinding) {
                        this.match.setRule(16);
                        return;
                    }
                }
                ++i;
            }
        }
        this.match.setRule(matchRule);
    }

    public int resolveLevel(Binding binding) {
        return 1;
    }

    protected int resolveLevelForType(char[] simpleNamePattern, char[] qualificationPattern, TypeBinding binding) {
        if (binding == TypeBinding.ANY || binding == TypeBinding.UNKNOWN) {
            return 3;
        }
        if (Arrays.equals(Signature.ANY, simpleNamePattern)) {
            return 3;
        }
        char[] qualifiedPattern = this.getQualifiedPattern(simpleNamePattern, qualificationPattern);
        int level = this.resolveLevelForType(qualifiedPattern, binding);
        if (level == 3 || binding == null) {
            return level;
        }
        TypeBinding type = binding instanceof ArrayBinding ? ((ArrayBinding)binding).leafComponentType : binding;
        char[] sourceName = null;
        if (type.isMemberType() || type.isLocalType()) {
            sourceName = qualificationPattern != null ? this.getQualifiedSourceName(binding) : binding.sourceName();
        } else if (qualificationPattern == null) {
            sourceName = this.getQualifiedSourceName(binding);
        }
        if (sourceName == null) {
            return 0;
        }
        boolean matchPattern = this.isAccurateNameMatch(qualifiedPattern, sourceName);
        return matchPattern ? 3 : 0;
    }

    protected int resolveLevelForType(char[] qualifiedPattern, TypeBinding type) {
        char[] fullyQualifiedTypeName;
        char[] filePath;
        if (qualifiedPattern == null) {
            return 3;
        }
        if (type == null) {
            return 1;
        }
        char[] bindingPath = filePath = new char[0];
        int index = CharOperation.lastIndexOf('/', qualifiedPattern);
        if (index > -1) {
            filePath = CharOperation.subarray(qualifiedPattern, 0, index);
            qualifiedPattern = CharOperation.subarray(qualifiedPattern, index + 1, qualifiedPattern.length);
            bindingPath = type.getFileName();
            index = CharOperation.lastIndexOf('/', bindingPath);
            if (index > -1) {
                bindingPath = CharOperation.subarray(bindingPath, 0, index);
            }
        }
        char[] qualifiedPackageName = type.qualifiedPackageName();
        char[] qualifiedSourceName = PatternLocator.qualifiedSourceName(type);
        char[] cArray = fullyQualifiedTypeName = qualifiedPackageName.length == 0 ? qualifiedSourceName : CharOperation.concat(qualifiedPackageName, qualifiedSourceName, '.');
        if (CharOperation.match(qualifiedPattern, fullyQualifiedTypeName, this.isCaseSensitive)) {
            if (filePath.length > 0) {
                return CharOperation.endsWith(bindingPath, filePath) ? 3 : 0;
            }
            return 3;
        }
        return 0;
    }

    protected int resolveLevelForType(char[] simpleNamePattern, char[] qualificationPattern, char[][][] patternTypeArguments, int depth, TypeBinding type) {
        int level = this.resolveLevelForType(simpleNamePattern, qualificationPattern, type);
        if (level == 0) {
            return 0;
        }
        if (type == null || patternTypeArguments == null || patternTypeArguments.length == 0 || depth >= patternTypeArguments.length) {
            return level;
        }
        return patternTypeArguments[depth] == null || patternTypeArguments[depth].length == 0 ? level : 0;
    }

    protected int resolveLevelUsingSearchPrefix(char[] searchPrefix, TypeBinding binding) {
        if (binding == TypeBinding.ANY || binding == TypeBinding.UNKNOWN) {
            return 3;
        }
        char[] sourceName = PatternLocator.qualifiedSourceName(binding);
        if (sourceName == null) {
            return 0;
        }
        if (this.isAccurateNameMatch(searchPrefix, sourceName)) {
            return 3;
        }
        int index = CharOperation.lastIndexOf('.', sourceName);
        if (index >= 0 && this.isAccurateNameMatch(searchPrefix, CharOperation.subarray(sourceName, index + 1, sourceName.length))) {
            return 3;
        }
        return 0;
    }

    public String toString() {
        return "SearchPattern";
    }

    public int matchMetadataElement(IJavaScriptElement element) {
        return 0;
    }
}

