/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.listeners;

import org.eclipse.jpt.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.utility.model.listener.StateChangeListener;
import org.eclipse.swt.widgets.Display;

public class SWTStateChangeListenerWrapper
implements StateChangeListener {
    private final StateChangeListener listener;

    public SWTStateChangeListenerWrapper(StateChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
    }

    public void stateChanged(StateChangeEvent event) {
        if (this.isExecutingUIThread()) {
            this.stateChanged_(event);
        } else {
            this.executeOnUIThread(this.buildRunnable(event));
        }
    }

    private Runnable buildRunnable(final StateChangeEvent event) {
        return new Runnable(){

            public void run() {
                SWTStateChangeListenerWrapper.this.stateChanged_(event);
            }
        };
    }

    private boolean isExecutingUIThread() {
        return Display.getCurrent() != null;
    }

    private void executeOnUIThread(Runnable r) {
        Display.getDefault().asyncExec(r);
    }

    void stateChanged_(StateChangeEvent event) {
        this.listener.stateChanged(event);
    }

    public String toString() {
        return "SWT(" + this.listener.toString() + ')';
    }
}

