/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.views;

import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.internal.selection.JpaSelection;
import org.eclipse.jpt.ui.internal.selection.JpaSelectionManager;
import org.eclipse.jpt.ui.internal.selection.SelectionManagerFactory;
import org.eclipse.jpt.ui.internal.widgets.FormWidgetFactory;
import org.eclipse.jpt.ui.internal.widgets.PropertySheetWidgetFactory;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public abstract class AbstractJpaView
extends ViewPart {
    private Composite defaultComposite;
    private String defaultLabel;
    private PageBook pageBook;
    private ScrolledForm scrolledForm;
    private WidgetFactory widgetFactory;

    public AbstractJpaView(String defaultLabel) {
        this.defaultLabel = defaultLabel;
        this.initialize();
    }

    private Composite buildDefaultComposite() {
        Composite composite = this.widgetFactory.createComposite((Composite)this.pageBook);
        composite.setLayout((Layout)new FillLayout(512));
        this.getWidgetFactory().createLabel(composite, this.defaultLabel);
        return composite;
    }

    public final void createPartControl(Composite parent) {
        this.scrolledForm = this.getFormWidgetFactory().createScrolledForm(parent);
        this.scrolledForm.getBody().setLayout((Layout)new GridLayout());
        this.pageBook = new PageBook(this.scrolledForm.getBody(), 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.pageBook.setLayoutData((Object)gridData);
        this.scrolledForm.setContent((Control)this.pageBook);
        this.defaultComposite = this.buildDefaultComposite();
        this.pageBook.showPage((Control)this.defaultComposite);
        this.subcreatePartControl(parent);
        JpaSelectionManager selectionManager = SelectionManagerFactory.getSelectionManager(this.getViewSite().getWorkbenchWindow());
        selectionManager.register((IWorkbenchPart)this);
        this.select(selectionManager.getCurrentSelection());
    }

    protected final PageBook getPageBook() {
        return this.pageBook;
    }

    public final WidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    protected void initialize() {
        this.widgetFactory = new PropertySheetWidgetFactory(new TabbedPropertySheetWidgetFactory());
    }

    private FormToolkit getFormWidgetFactory() {
        return ((FormWidgetFactory)this.widgetFactory).getWidgetFactory();
    }

    public abstract void select(JpaSelection var1);

    public void setFocus() {
        this.pageBook.setFocus();
    }

    protected void showDefaultPage() {
        this.showPage((Control)this.defaultComposite);
    }

    protected final void showPage(Control page) {
        page.setParent((Composite)this.pageBook);
        this.pageBook.showPage(page);
        this.scrolledForm.reflow(true);
    }

    protected void subcreatePartControl(Composite parent) {
    }
}

