/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.SynchronizedObject;
import org.eclipse.jpt.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedObjectTests
extends TestCase {
    private volatile SynchronizedObject<Object> so;
    private volatile boolean exCaught;
    private volatile boolean timeoutOccurred;
    volatile Object value = new Object();
    private volatile long startTime;
    private volatile long endTime;
    private volatile Object soValue;

    public SynchronizedObjectTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.so = new SynchronizedObject();
        this.exCaught = false;
        this.timeoutOccurred = false;
        this.startTime = 0L;
        this.endTime = 0L;
        this.soValue = null;
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testAccessors() throws Exception {
        this.so.setValue(null);
        SynchronizedObjectTests.assertNull((Object)this.so.value());
        SynchronizedObjectTests.assertFalse((boolean)this.so.isNotNull());
        SynchronizedObjectTests.assertTrue((boolean)this.so.isNull());
        this.so.setValue(this.value);
        SynchronizedObjectTests.assertEquals((Object)this.value, (Object)this.so.value());
        SynchronizedObjectTests.assertTrue((boolean)this.so.isNotNull());
        SynchronizedObjectTests.assertFalse((boolean)this.so.isNull());
        this.so.setNull();
        SynchronizedObjectTests.assertNull((Object)this.so.value());
        SynchronizedObjectTests.assertFalse((boolean)this.so.isNotNull());
        SynchronizedObjectTests.assertTrue((boolean)this.so.isNull());
        SynchronizedObjectTests.assertSame(this.so, (Object)this.so.mutex());
    }

    public void testEquals() throws Exception {
        this.so.setValue(null);
        SynchronizedObject so2 = new SynchronizedObject(null);
        SynchronizedObjectTests.assertEquals(this.so, (Object)so2);
        this.so.setValue(this.value);
        SynchronizedObjectTests.assertFalse((boolean)this.so.equals((Object)so2));
        so2.setValue(this.value);
        SynchronizedObjectTests.assertEquals(this.so, (Object)so2);
    }

    public void testHashCode() {
        this.so.setValue(this.value);
        SynchronizedObjectTests.assertEquals((int)this.value.hashCode(), (int)this.so.hashCode());
        this.so.setValue(null);
        SynchronizedObjectTests.assertEquals((int)0, (int)this.so.hashCode());
    }

    public void testWaitUntilNull() throws Exception {
        this.verifyWaitUntilNull(0L);
        SynchronizedObjectTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedObjectTests.assertNull((Object)this.so.value());
        long time = this.elapsedTime();
        SynchronizedObjectTests.assertTrue((String)("t2 finished a bit early (expected value should be > 150): " + time), (time > 150L ? 1 : 0) != 0);
    }

    public void testWaitUntilNullTimeout() throws Exception {
        this.verifyWaitUntilNull(20L);
        SynchronizedObjectTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedObjectTests.assertNull((Object)this.so.value());
        long time = this.elapsedTime();
        SynchronizedObjectTests.assertTrue((String)("t2 finished a bit late (expected value should be < 150): " + time), (time < 150L ? 1 : 0) != 0);
    }

    private void verifyWaitUntilNull(long t2Timeout) throws Exception {
        this.executeThreads(this.buildSetNullCommand(), this.buildWaitUntilNullCommand(t2Timeout));
    }

    public void testWaitToSetValue() throws Exception {
        this.verifyWaitToSetValue(0L);
        SynchronizedObjectTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedObjectTests.assertTrue((boolean)this.so.isNotNull());
        long time = this.elapsedTime();
        SynchronizedObjectTests.assertTrue((String)("t2 finished a bit early (expected value should be > 150): " + time), (time > 150L ? 1 : 0) != 0);
    }

    public void testWaitToSetValueTimeout() throws Exception {
        this.verifyWaitToSetValue(20L);
        SynchronizedObjectTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedObjectTests.assertTrue((boolean)this.so.isNull());
        long time = this.elapsedTime();
        SynchronizedObjectTests.assertTrue((String)("t2 finished a bit late (expected value should be < 150): " + time), (time < 150L ? 1 : 0) != 0);
    }

    private void verifyWaitToSetValue(long t2Timeout) throws Exception {
        this.executeThreads(this.buildSetNullCommand(), this.buildWaitToSetValueCommand(t2Timeout));
    }

    public void testExecute() throws Exception {
        this.so.setValue(null);
        Runnable r1 = this.buildRunnable(this.buildInitializeValueCommand(), this.so, 0L);
        Runnable r2 = this.buildRunnable(this.buildGetValueCommand(), this.so, 100L);
        Thread t1 = new Thread(r1);
        Thread t2 = new Thread(r2);
        t1.start();
        t2.start();
        while (t1.isAlive() || t2.isAlive()) {
            Thread.sleep(50L);
        }
        SynchronizedObjectTests.assertFalse((boolean)this.exCaught);
        SynchronizedObjectTests.assertEquals((Object)"foo", (Object)this.so.value());
        SynchronizedObjectTests.assertEquals((Object)"foo", (Object)this.soValue);
        long time = this.elapsedTime();
        SynchronizedObjectTests.assertTrue((String)("t2 finished a bit early (expected value should be > 100): " + time), (time > 300L ? 1 : 0) != 0);
    }

    private void executeThreads(Command t1Command, Command t2Command) throws Exception {
        this.so.setValue(this.value);
        Runnable r1 = this.buildRunnable(t1Command, this.so, 200L);
        Runnable r2 = this.buildRunnable(t2Command, this.so, 0L);
        Thread t1 = new Thread(r1);
        Thread t2 = new Thread(r2);
        t1.start();
        t2.start();
        while (t1.isAlive() || t2.isAlive()) {
            Thread.sleep(50L);
        }
        SynchronizedObjectTests.assertFalse((boolean)this.exCaught);
    }

    private Command buildSetNullCommand() {
        return new Command(){

            @Override
            public void execute(SynchronizedObject<Object> sObject) {
                sObject.setNull();
            }
        };
    }

    private Command buildWaitUntilNullCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedObject<Object> sObject) throws Exception {
                SynchronizedObjectTests.this.setStartTime(System.currentTimeMillis());
                SynchronizedObjectTests.this.setTimeoutOccurred(!sObject.waitUntilNull(timeout));
                SynchronizedObjectTests.this.setEndTime(System.currentTimeMillis());
            }
        };
    }

    private Command buildWaitToSetValueCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedObject<Object> sObject) throws Exception {
                SynchronizedObjectTests.this.setStartTime(System.currentTimeMillis());
                SynchronizedObjectTests.this.setTimeoutOccurred(!sObject.waitToSetValue(SynchronizedObjectTests.this.value, timeout));
                SynchronizedObjectTests.this.setEndTime(System.currentTimeMillis());
            }
        };
    }

    private Command buildInitializeValueCommand() {
        return new Command(){

            @Override
            public void execute(final SynchronizedObject<Object> sObject) throws Exception {
                sObject.execute(new org.eclipse.jpt.utility.Command(){

                    public void execute() {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                            SynchronizedObjectTests.this.setExCaught(true);
                        }
                        sObject.setValue((Object)"foo");
                    }
                });
            }
        };
    }

    private Command buildGetValueCommand() {
        return new Command(){

            @Override
            public void execute(SynchronizedObject<Object> sObject) throws Exception {
                SynchronizedObjectTests.this.setStartTime(System.currentTimeMillis());
                SynchronizedObjectTests.this.setSOValue(sObject.value());
                SynchronizedObjectTests.this.setEndTime(System.currentTimeMillis());
            }
        };
    }

    private Runnable buildRunnable(final Command command, final SynchronizedObject<Object> sObject, final long sleep) {
        return new Runnable(){

            public void run() {
                try {
                    if (sleep != 0L) {
                        Thread.sleep(sleep);
                    }
                    command.execute((SynchronizedObject<Object>)sObject);
                }
                catch (Exception exception) {
                    SynchronizedObjectTests.this.setExCaught(true);
                }
            }
        };
    }

    void setExCaught(boolean exCaught) {
        this.exCaught = exCaught;
    }

    void setTimeoutOccurred(boolean timeoutOccurred) {
        this.timeoutOccurred = timeoutOccurred;
    }

    void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    private long elapsedTime() {
        return this.endTime - this.startTime;
    }

    void setSOValue(Object soValue) {
        this.soValue = soValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Command {
        public void execute(SynchronizedObject<Object> var1) throws Exception;
    }
}

