/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model;

import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.ChangeEvent;
import org.eclipse.jpt.utility.model.listener.ChangeListener;
import org.eclipse.jpt.utility.tests.internal.TestTools;

public class NewEventTests
extends TestCase {
    private Foo foo;

    public NewEventTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.foo = new Foo();
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testHasNoFooChangeListeners() {
        NewEventTests.assertTrue((boolean)this.foo.hasNoFooChangeListeners());
        LocalListener listener = new LocalListener();
        this.foo.addFooChangeListener(listener);
        NewEventTests.assertFalse((boolean)this.foo.hasNoFooChangeListeners());
        this.foo.removeFooChangeListener(listener);
        NewEventTests.assertTrue((boolean)this.foo.hasNoFooChangeListeners());
    }

    public void testHasAnyFooChangeListeners() {
        NewEventTests.assertFalse((boolean)this.foo.hasAnyFooChangeListeners());
        LocalListener listener = new LocalListener();
        this.foo.addFooChangeListener(listener);
        NewEventTests.assertTrue((boolean)this.foo.hasAnyFooChangeListeners());
        this.foo.removeFooChangeListener(listener);
        NewEventTests.assertFalse((boolean)this.foo.hasAnyFooChangeListeners());
    }

    public void testFireFooChangeEvent() {
        LocalListener listener = new LocalListener();
        NewEventTests.assertFalse((boolean)listener.receivedFooEvent);
        this.foo.addFooChangeListener(listener);
        this.foo.foo();
        NewEventTests.assertTrue((boolean)listener.receivedFooEvent);
    }

    static class AbstractFooModel
    extends AbstractModel
    implements FooModel {
        AbstractFooModel() {
        }

        protected synchronized FooChangeSupport getChangeSupport() {
            return (FooChangeSupport)super.getChangeSupport();
        }

        protected ChangeSupport buildChangeSupport() {
            return new FooChangeSupport(this);
        }

        public void addFooChangeListener(FooChangeListener listener) {
            this.getChangeSupport().addFooChangeListener(listener);
        }

        public void removeFooChangeListener(FooChangeListener listener) {
            this.getChangeSupport().removeFooChangeListener(listener);
        }

        protected void fireFooChangeEvent() {
            this.getChangeSupport().fireFooChanged();
        }

        public boolean hasAnyFooChangeListeners() {
            return this.getChangeSupport().hasAnyFooChangeListeners();
        }

        public boolean hasNoFooChangeListeners() {
            return !this.hasAnyFooChangeListeners();
        }
    }

    class Foo
    extends AbstractFooModel {
        Foo() {
        }

        void foo() {
            this.fireFooChangeEvent();
        }
    }

    static class FooChangeEvent
    extends ChangeEvent {
        private static final long serialVersionUID = 1L;

        public FooChangeEvent(FooModel source) {
            super((Model)source);
        }

        public String getAspectName() {
            return null;
        }

        public FooChangeEvent cloneWithSource(Model newSource) {
            return new FooChangeEvent((FooModel)newSource);
        }
    }

    static interface FooChangeListener
    extends ChangeListener {
        public void fooChanged(FooChangeEvent var1);
    }

    static class FooChangeSupport
    extends ChangeSupport {
        protected static final Class<FooChangeListener> FOO_CHANGE_LISTENER_CLASS = FooChangeListener.class;

        FooChangeSupport(FooModel source) {
            super((Model)source);
        }

        void addFooChangeListener(FooChangeListener listener) {
            this.addListener(FOO_CHANGE_LISTENER_CLASS, listener);
        }

        void removeFooChangeListener(FooChangeListener listener) {
            this.removeListener(FOO_CHANGE_LISTENER_CLASS, listener);
        }

        public boolean hasAnyFooChangeListeners() {
            return this.hasAnyListeners(FOO_CHANGE_LISTENER_CLASS);
        }

        private FooChangeListener[] fooChangeListeners() {
            return (FooChangeListener[])this.getListeners(FOO_CHANGE_LISTENER_CLASS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireFooChanged() {
            FooChangeListener[] targets = null;
            FooChangeSupport fooChangeSupport = this;
            synchronized (fooChangeSupport) {
                FooChangeListener[] fooChangeListeners = this.fooChangeListeners();
                if (fooChangeListeners != null) {
                    targets = (FooChangeListener[])fooChangeListeners.clone();
                }
            }
            if (targets != null) {
                FooChangeEvent event = null;
                FooChangeListener[] fooChangeListenerArray = targets;
                int n = targets.length;
                int n2 = 0;
                while (n2 < n) {
                    boolean stillListening;
                    FooChangeListener target = fooChangeListenerArray[n2];
                    FooChangeSupport fooChangeSupport2 = this;
                    synchronized (fooChangeSupport2) {
                        stillListening = CollectionTools.contains((Object[])this.fooChangeListeners(), (Object)target);
                    }
                    if (stillListening) {
                        if (event == null) {
                            event = new FooChangeEvent((FooModel)this.source);
                        }
                        target.fooChanged(event);
                    }
                    ++n2;
                }
            }
            this.aspectChanged(null);
        }
    }

    static interface FooModel
    extends Model {
        public void addFooChangeListener(FooChangeListener var1);

        public void removeFooChangeListener(FooChangeListener var1);
    }

    class LocalListener
    implements FooChangeListener {
        boolean receivedFooEvent = false;

        LocalListener() {
        }

        public void fooChanged(FooChangeEvent event) {
            this.receivedFooEvent = true;
        }
    }
}

