/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import org.eclipse.jpt.utility.internal.model.value.AspectPropertyValueModelAdapter;
import org.eclipse.jpt.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionPropertyValueModelAdapter<T>
extends AspectPropertyValueModelAdapter<T> {
    protected final CollectionValueModel<?> collectionHolder;
    protected final CollectionChangeListener collectionChangeListener;

    protected CollectionPropertyValueModelAdapter(CollectionValueModel<?> collectionHolder) {
        this.collectionHolder = collectionHolder;
        this.collectionChangeListener = this.buildCollectionChangeListener();
    }

    protected CollectionChangeListener buildCollectionChangeListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent event) {
                CollectionPropertyValueModelAdapter.this.itemsAdded(event);
            }

            public void itemsRemoved(CollectionChangeEvent event) {
                CollectionPropertyValueModelAdapter.this.itemsRemoved(event);
            }

            public void collectionCleared(CollectionChangeEvent event) {
                CollectionPropertyValueModelAdapter.this.collectionCleared(event);
            }

            public void collectionChanged(CollectionChangeEvent event) {
                CollectionPropertyValueModelAdapter.this.collectionChanged(event);
            }

            public String toString() {
                return "collection change listener";
            }
        };
    }

    @Override
    protected void engageModel_() {
        this.collectionHolder.addCollectionChangeListener("values", this.collectionChangeListener);
    }

    @Override
    protected void disengageModel_() {
        this.collectionHolder.removeCollectionChangeListener("values", this.collectionChangeListener);
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.collectionHolder);
    }

    protected void itemsAdded(CollectionChangeEvent event) {
        this.propertyChanged();
    }

    protected void itemsRemoved(CollectionChangeEvent event) {
        this.propertyChanged();
    }

    protected void collectionCleared(CollectionChangeEvent event) {
        this.propertyChanged();
    }

    protected void collectionChanged(CollectionChangeEvent event) {
        this.propertyChanged();
    }
}

