/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.model.value.AspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.StaticPropertyValueModel;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.listener.ChangeListener;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListAspectAdapter<S extends Model, E>
extends AspectAdapter<S>
implements ListValueModel<E> {
    protected final String[] listNames;
    protected static final String[] EMPTY_LIST_NAMES = new String[0];
    protected final ListChangeListener listChangeListener;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    protected ListAspectAdapter(String listName, S subject) {
        this(new String[]{listName}, subject);
    }

    protected ListAspectAdapter(String[] listNames, S subject) {
        this(new StaticPropertyValueModel<S>(subject), listNames);
    }

    protected ListAspectAdapter(PropertyValueModel<? extends S> subjectHolder, String ... listNames) {
        super(subjectHolder);
        this.listNames = listNames;
        this.listChangeListener = this.buildListChangeListener();
    }

    protected ListAspectAdapter(PropertyValueModel<? extends S> subjectHolder, Collection<String> listNames) {
        this(subjectHolder, listNames.toArray(new String[listNames.size()]));
    }

    protected ListAspectAdapter(PropertyValueModel<? extends S> subjectHolder) {
        this(subjectHolder, EMPTY_LIST_NAMES);
    }

    protected ListChangeListener buildListChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent event) {
                ListAspectAdapter.this.itemsAdded(event);
            }

            public void itemsRemoved(ListChangeEvent event) {
                ListAspectAdapter.this.itemsRemoved(event);
            }

            public void itemsReplaced(ListChangeEvent event) {
                ListAspectAdapter.this.itemsReplaced(event);
            }

            public void itemsMoved(ListChangeEvent event) {
                ListAspectAdapter.this.itemsMoved(event);
            }

            public void listCleared(ListChangeEvent event) {
                ListAspectAdapter.this.listCleared(event);
            }

            public void listChanged(ListChangeEvent event) {
                ListAspectAdapter.this.listChanged(event);
            }

            public String toString() {
                return "list change listener: " + Arrays.asList(ListAspectAdapter.this.listNames);
            }
        };
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.subject == null ? EmptyListIterator.instance() : this.listIterator_();
    }

    protected ListIterator<E> listIterator_() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E get(int index) {
        return CollectionTools.get(this.listIterator(), index);
    }

    @Override
    public int size() {
        return this.subject == null ? 0 : this.size_();
    }

    protected int size_() {
        return CollectionTools.size(this.listIterator());
    }

    @Override
    public Object[] toArray() {
        return this.subject == null ? EMPTY_ARRAY : this.toArray_();
    }

    protected Object[] toArray_() {
        return CollectionTools.array(this.listIterator(), this.size());
    }

    @Override
    protected Object getValue() {
        return this.iterator();
    }

    @Override
    protected Class<? extends ChangeListener> getListenerClass() {
        return ListChangeListener.class;
    }

    @Override
    protected String getListenerAspectName() {
        return "list values";
    }

    @Override
    protected boolean hasListeners() {
        return this.hasAnyListChangeListeners("list values");
    }

    @Override
    protected void fireAspectChange(Object oldValue, Object newValue) {
        this.fireListChanged("list values");
    }

    @Override
    protected void engageSubject_() {
        String[] stringArray = this.listNames;
        int n = this.listNames.length;
        int n2 = 0;
        while (n2 < n) {
            String listName = stringArray[n2];
            ((Model)this.subject).addListChangeListener(listName, this.listChangeListener);
            ++n2;
        }
    }

    @Override
    protected void disengageSubject_() {
        String[] stringArray = this.listNames;
        int n = this.listNames.length;
        int n2 = 0;
        while (n2 < n) {
            String listName = stringArray[n2];
            ((Model)this.subject).removeListChangeListener(listName, this.listChangeListener);
            ++n2;
        }
    }

    @Override
    public void toString(StringBuilder sb) {
        int i = 0;
        while (i < this.listNames.length) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.listNames[i]);
            ++i;
        }
    }

    protected void itemsAdded(ListChangeEvent event) {
        this.fireItemsAdded(event.cloneWithSource(this, "list values"));
    }

    protected void itemsRemoved(ListChangeEvent event) {
        this.fireItemsRemoved(event.cloneWithSource(this, "list values"));
    }

    protected void itemsReplaced(ListChangeEvent event) {
        this.fireItemsReplaced(event.cloneWithSource(this, "list values"));
    }

    protected void itemsMoved(ListChangeEvent event) {
        this.fireItemsMoved(event.cloneWithSource(this, "list values"));
    }

    protected void listCleared(ListChangeEvent event) {
        this.fireListCleared("list values");
    }

    protected void listChanged(ListChangeEvent event) {
        this.fireListChanged("list values");
    }
}

