/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.model.value.AspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.StaticPropertyValueModel;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.TreeChangeEvent;
import org.eclipse.jpt.utility.model.listener.ChangeListener;
import org.eclipse.jpt.utility.model.listener.TreeChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.TreeValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TreeAspectAdapter<S extends Model, E>
extends AspectAdapter<S>
implements TreeValueModel<E> {
    protected final String[] treeNames;
    protected static final String[] EMPTY_TREE_NAMES = new String[0];
    protected final TreeChangeListener treeChangeListener;

    protected TreeAspectAdapter(String treeName, S subject) {
        this(new String[]{treeName}, subject);
    }

    protected TreeAspectAdapter(String[] treeNames, S subject) {
        this(new StaticPropertyValueModel<S>(subject), treeNames);
    }

    protected TreeAspectAdapter(PropertyValueModel<? extends S> subjectHolder, String ... treeNames) {
        super(subjectHolder);
        this.treeNames = treeNames;
        this.treeChangeListener = this.buildTreeChangeListener();
    }

    protected TreeAspectAdapter(PropertyValueModel<? extends S> subjectHolder, Collection<String> treeNames) {
        this(subjectHolder, treeNames.toArray(new String[treeNames.size()]));
    }

    protected TreeAspectAdapter(PropertyValueModel<? extends S> subjectHolder) {
        this(subjectHolder, EMPTY_TREE_NAMES);
    }

    protected TreeChangeListener buildTreeChangeListener() {
        return new TreeChangeListener(){

            public void nodeAdded(TreeChangeEvent event) {
                TreeAspectAdapter.this.nodeAdded(event);
            }

            public void nodeRemoved(TreeChangeEvent event) {
                TreeAspectAdapter.this.nodeRemoved(event);
            }

            public void treeCleared(TreeChangeEvent event) {
                TreeAspectAdapter.this.treeCleared(event);
            }

            public void treeChanged(TreeChangeEvent event) {
                TreeAspectAdapter.this.treeChanged(event);
            }

            public String toString() {
                return "tree change listener: " + Arrays.asList(TreeAspectAdapter.this.treeNames);
            }
        };
    }

    @Override
    public Iterator<E> nodes() {
        return this.subject == null ? EmptyIterator.instance() : this.nodes_();
    }

    protected Iterator<E> nodes_() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object getValue() {
        return this.nodes();
    }

    @Override
    protected Class<? extends ChangeListener> getListenerClass() {
        return TreeChangeListener.class;
    }

    @Override
    protected String getListenerAspectName() {
        return "nodes";
    }

    @Override
    protected boolean hasListeners() {
        return this.hasAnyTreeChangeListeners("nodes");
    }

    @Override
    protected void fireAspectChange(Object oldValue, Object newValue) {
        this.fireTreeChanged("nodes");
    }

    @Override
    protected void engageSubject_() {
        String[] stringArray = this.treeNames;
        int n = this.treeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String treeName = stringArray[n2];
            ((Model)this.subject).addTreeChangeListener(treeName, this.treeChangeListener);
            ++n2;
        }
    }

    @Override
    protected void disengageSubject_() {
        String[] stringArray = this.treeNames;
        int n = this.treeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String treeName = stringArray[n2];
            ((Model)this.subject).removeTreeChangeListener(treeName, this.treeChangeListener);
            ++n2;
        }
    }

    @Override
    public void toString(StringBuilder sb) {
        int i = 0;
        while (i < this.treeNames.length) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.treeNames[i]);
            ++i;
        }
    }

    protected void nodeAdded(TreeChangeEvent event) {
        this.fireNodeAdded("nodes", event.getPath());
    }

    protected void nodeRemoved(TreeChangeEvent event) {
        this.fireNodeRemoved("nodes", event.getPath());
    }

    protected void treeCleared(TreeChangeEvent event) {
        this.fireTreeCleared("nodes");
    }

    protected void treeChanged(TreeChangeEvent event) {
        this.fireTreeChanged("nodes", event.getPath());
    }
}

