/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value.swing;

import org.eclipse.jpt.utility.internal.BidiFilter;
import org.eclipse.jpt.utility.internal.BidiTransformer;
import org.eclipse.jpt.utility.internal.model.value.FilteringWritablePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationWritablePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ToggleButtonModelAdapter;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadioButtonModelAdapter
extends ToggleButtonModelAdapter {
    public RadioButtonModelAdapter(WritablePropertyValueModel<Object> valueHolder, Object buttonValue, boolean defaultValue) {
        super(RadioButtonModelAdapter.buildBooleanHolder(valueHolder, buttonValue), defaultValue);
    }

    public RadioButtonModelAdapter(WritablePropertyValueModel<Object> valueHolder, Object buttonValue) {
        super(RadioButtonModelAdapter.buildBooleanHolder(valueHolder, buttonValue));
    }

    public static WritablePropertyValueModel<Boolean> buildBooleanHolder(WritablePropertyValueModel<Object> valueHolder, Object buttonValue) {
        FilteringWritablePropertyValueModel<Object> filteringPVM = new FilteringWritablePropertyValueModel<Object>(valueHolder, new RadioButtonFilter(buttonValue));
        return new TransformationWritablePropertyValueModel<Object, Boolean>((WritablePropertyValueModel<Object>)filteringPVM, new RadioButtonTransformer(buttonValue));
    }

    @Override
    public void setSelected(boolean b) {
        if (!b && this.isArmed()) {
            return;
        }
        super.setSelected(b);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RadioButtonFilter
    implements BidiFilter<Object> {
        private Object buttonValue;

        public RadioButtonFilter(Object buttonValue) {
            this.buttonValue = buttonValue;
        }

        @Override
        public boolean accept(Object value) {
            return true;
        }

        @Override
        public boolean reverseAccept(Object value) {
            return value == this.buttonValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RadioButtonTransformer
    implements BidiTransformer<Object, Boolean> {
        private Object buttonValue;

        public RadioButtonTransformer(Object buttonValue) {
            this.buttonValue = buttonValue;
        }

        @Override
        public Boolean transform(Object value) {
            return value == null ? null : Boolean.valueOf(value == this.buttonValue);
        }

        @Override
        public Object reverseTransform(Boolean value) {
            return value != false ? this.buttonValue : null;
        }
    }
}

