/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.swing;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jpt.utility.internal.swing.TableCellEditorAdapter;

public class SpinnerTableCellRenderer
implements TableCellEditorAdapter.Renderer {
    protected JSpinner spinner;
    protected TableCellEditorAdapter.ImmediateEditListener immediateEditListener;

    public SpinnerTableCellRenderer() {
        this.initialize();
    }

    public SpinnerTableCellRenderer(SpinnerModel model) {
        this();
        this.setModel(model);
    }

    protected void initialize() {
        this.spinner = this.buildSpinner();
    }

    protected JSpinner buildSpinner() {
        JSpinner s = new JSpinner();
        s.addChangeListener(this.buildChangeListener());
        return s;
    }

    private ChangeListener buildChangeListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (SpinnerTableCellRenderer.this.immediateEditListener != null) {
                    SpinnerTableCellRenderer.this.immediateEditListener.immediateEdit();
                }
            }
        };
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
        this.spinner.setComponentOrientation(table.getComponentOrientation());
        this.spinner.setFont(table.getFont());
        this.spinner.setEnabled(table.isEnabled());
        JComponent editor = this.editor();
        editor.setForeground(this.foregroundColor(table, value, selected, hasFocus, row, column));
        editor.setBackground(this.backgroundColor(table, value, selected, hasFocus, row, column));
        this.spinner.setBorder(this.border(table, value, selected, hasFocus, row, column));
        this.setValue(value);
        return this.spinner;
    }

    protected Color foregroundColor(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
        if (selected) {
            if (hasFocus && table.isCellEditable(row, column)) {
                return UIManager.getColor("Table.focusCellForeground");
            }
            return table.getSelectionForeground();
        }
        return table.getForeground();
    }

    protected Color backgroundColor(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
        if (selected) {
            if (hasFocus && table.isCellEditable(row, column)) {
                return UIManager.getColor("Table.focusCellBackground");
            }
            return table.getSelectionBackground();
        }
        return table.getBackground();
    }

    protected Border border(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
        if (hasFocus) {
            return UIManager.getBorder("Table.focusCellHighlightBorder");
        }
        if (selected) {
            return BorderFactory.createLineBorder(table.getSelectionBackground(), 1);
        }
        return BorderFactory.createLineBorder(table.getBackground(), 1);
    }

    protected JComponent editor() {
        JComponent editor = this.spinner.getEditor();
        if (editor instanceof JSpinner.DefaultEditor) {
            editor = ((JSpinner.DefaultEditor)editor).getTextField();
        }
        return editor;
    }

    protected void setValue(Object value) {
        if (value == null) {
            value = new Integer(0);
        }
        this.spinner.setValue(value);
    }

    public Object getValue() {
        return this.spinner.getValue();
    }

    public void setImmediateEditListener(TableCellEditorAdapter.ImmediateEditListener listener) {
        this.immediateEditListener = listener;
    }

    public void setModel(SpinnerModel model) {
        this.spinner.setModel(model);
    }

    public int preferredHeight() {
        return (int)this.spinner.getPreferredSize().getHeight() + 2;
    }
}

