/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.model.event;

import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.ChangeEvent;

public class TreeChangeEvent
extends ChangeEvent {
    private final String treeName;
    protected final Object[] path;
    private static final Object[] EMPTY_PATH = new Object[0];
    private static final long serialVersionUID = 1L;

    public TreeChangeEvent(Model source, String treeName, Object[] path) {
        super(source);
        if (treeName == null || path == null) {
            throw new NullPointerException();
        }
        this.treeName = treeName;
        this.path = path;
    }

    public TreeChangeEvent(Model source, String treeName) {
        this(source, treeName, EMPTY_PATH);
    }

    public String getTreeName() {
        return this.treeName;
    }

    public String getAspectName() {
        return this.treeName;
    }

    public Object[] getPath() {
        return this.path;
    }

    public TreeChangeEvent cloneWithSource(Model newSource) {
        return new TreeChangeEvent(newSource, this.treeName, this.path);
    }

    public TreeChangeEvent cloneWithSource(Model newSource, String newTreeName) {
        return new TreeChangeEvent(newSource, newTreeName, this.path);
    }
}

