/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jst.j2ee.internal.delete.DeleteOptions;
import org.eclipse.jst.j2ee.internal.dialogs.DeleteEARDialog;
import org.eclipse.jst.j2ee.internal.dialogs.DeleteModuleReferencesComposite;
import org.eclipse.jst.j2ee.internal.dialogs.J2EEDeleteUIConstants;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.model.WorkbenchLabelProvider;

@Deprecated
public class DeleteEARComposite
extends Composite
implements J2EEDeleteUIConstants,
Listener,
ICheckStateListener {
    protected DeleteEARDialog dialog;
    protected Button deleteAppProjectsBtn;
    protected Button deleteRefProjectsBtn;
    protected Composite radioComposite;
    protected Button detailsBtn;
    protected DeleteModuleReferencesComposite moduleRefsComposite;
    protected CheckboxTableViewer projectsList;
    protected boolean listCreated = false;
    protected Map referencedProjects;
    protected WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();

    public DeleteEARComposite(Composite parent, DeleteEARDialog dialog, int style, Set referencedProjects) {
        super(parent, style);
        this.dialog = dialog;
        this.initReferencedProjects(referencedProjects);
        this.addChildren();
    }

    public List getSelectedReferencedProjects() {
        if (this.deleteAppProjectsBtn.getSelection()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        for (Map.Entry element : this.referencedProjects.entrySet()) {
            boolean isSelected = (Boolean)element.getValue();
            if (!isSelected) continue;
            result.add(element.getKey());
        }
        return result;
    }

    public DeleteOptions createDeleteOptions() {
        DeleteOptions opts = new DeleteOptions();
        opts.setIsEARDelete(true);
        opts.setDeleteProjects(true);
        opts.setDeleteModuleDependencies(this.moduleRefsComposite.shouldDeleteModuleDependencies());
        opts.setDeleteModules(this.moduleRefsComposite.shouldDeleteModules());
        opts.setSelectedReferencedProjects(this.getSelectedReferencedProjects());
        return opts;
    }

    protected void initReferencedProjects(Set projects) {
        this.referencedProjects = new HashMap();
        for (IProject project : projects) {
            this.referencedProjects.put(project, Boolean.TRUE);
        }
    }

    protected void addChildren() {
        this.setLayout();
        this.addRadioComposite();
        this.moduleRefsComposite = new DeleteModuleReferencesComposite(this, 0, true);
        GridData data = new GridData(32);
        data.horizontalIndent = 10;
        this.moduleRefsComposite.setLayoutData(data);
        this.deleteAppProjectsBtn.setSelection(true);
        this.deleteAppProjectsBtnSelected();
    }

    protected void setLayout() {
        GridLayout lay = new GridLayout();
        lay.numColumns = 1;
        this.setLayout((Layout)lay);
        GridData data = new GridData(1808);
        this.setLayoutData(data);
    }

    protected void addRadioComposite() {
        this.radioComposite = new Composite((Composite)this, 0);
        GridLayout lay = new GridLayout();
        lay.numColumns = 2;
        this.radioComposite.setLayout((Layout)lay);
        GridData data = new GridData(1808);
        this.radioComposite.setLayoutData((Object)data);
        this.deleteAppProjectsBtn = new Button(this.radioComposite, 16);
        this.deleteAppProjectsBtn.setText(DELETE_EAR_PROJECTS);
        this.deleteAppProjectsBtn.addListener(13, (Listener)this);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.deleteAppProjectsBtn.setLayoutData((Object)data);
        this.deleteRefProjectsBtn = new Button(this.radioComposite, 16);
        this.deleteRefProjectsBtn.setText(DELETE_REFERENCED_PROJECTS);
        this.deleteRefProjectsBtn.addListener(13, (Listener)this);
        this.deleteRefProjectsBtn.setLayoutData((Object)new GridData(256));
        this.detailsBtn = new Button(this.radioComposite, 8);
        this.detailsBtn.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        this.detailsBtn.setLayoutData((Object)new GridData(128));
        this.detailsBtn.addListener(13, (Listener)this);
        this.detailsBtn.setEnabled(false);
    }

    public void handleEvent(Event event) {
        if (event.widget == this.deleteAppProjectsBtn) {
            this.deleteAppProjectsBtnSelected();
        } else if (event.widget == this.deleteRefProjectsBtn) {
            this.deleteRefProjectsBtnSelected();
        } else if (event.widget == this.detailsBtn) {
            this.detailsBtnSelected();
        }
    }

    protected void deleteAppProjectsBtnSelected() {
        if (this.deleteAppProjectsBtn.getSelection()) {
            if (this.listCreated) {
                this.toggleDetailsArea();
            }
            this.detailsBtn.setEnabled(false);
            this.moduleRefsComposite.setButtonsEnabled(false);
        }
    }

    protected void deleteRefProjectsBtnSelected() {
        if (this.deleteRefProjectsBtn.getSelection()) {
            this.detailsBtn.setEnabled(true);
            this.moduleRefsComposite.setButtonsEnabled(true);
        }
    }

    protected void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        Point oldSize = this.dialog.getContents().computeSize(-1, -1);
        if (this.listCreated) {
            this.projectsList.getControl().dispose();
            this.listCreated = false;
            this.detailsBtn.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        } else {
            this.createDropDownList();
            this.detailsBtn.setText(IDialogConstants.HIDE_DETAILS_LABEL);
        }
        Point newSize = this.dialog.getContents().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, windowSize.y + (newSize.y - oldSize.y)));
    }

    protected void createDropDownList() {
        this.projectsList = CheckboxTableViewer.newCheckList((Composite)this.radioComposite, (int)2816);
        this.projectsList.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.projectsList.setSorter(new ViewerSorter(){});
        this.projectsList.addCheckStateListener((ICheckStateListener)this);
        this.populateList();
        GridData data = new GridData(1808);
        data.heightHint = this.projectsList.getTable().getItemHeight() * this.referencedProjects.size();
        data.horizontalSpan = 2;
        data.horizontalIndent = 10;
        this.projectsList.getTable().setLayoutData((Object)data);
        this.listCreated = true;
    }

    protected void populateList() {
        for (Map.Entry entry : this.referencedProjects.entrySet()) {
            this.projectsList.add(entry.getKey());
            boolean checked = (Boolean)entry.getValue();
            this.projectsList.setChecked(entry.getKey(), checked);
        }
    }

    protected void detailsBtnSelected() {
        this.toggleDetailsArea();
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        this.referencedProjects.put(event.getElement(), new Boolean(event.getChecked()));
    }

    protected ITableLabelProvider createLabelProvider() {
        return new ITableLabelProvider(){

            public void dispose() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return DeleteEARComposite.this.workbenchLabelProvider.getImage(element);
            }

            public String getColumnText(Object element, int columnIndex) {
                return DeleteEARComposite.this.workbenchLabelProvider.getText(element);
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
    }
}

