/*******************************************************************************
 * Copyright (c) 2004, 2006 Sybase, Inc. and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Sybase, Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.jsf.facesconfig.ui.preference;

import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transform;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

/**
 * A figure decorator
 *
 */
/*package*/ class BaseFigureDecorator extends Label implements RotatableDecoration

{

	/**
	 * The default position for the decorator
	 */
	protected static int DEFAULT_DECORATOR_POSITION = 
		PositionConstants.SOUTH_WEST;

	private Point location = new Point();

	private Transform transform = new Transform();

	private int position;

	/**
	 * @param image
	 */
	public BaseFigureDecorator(Image image)

	{

		this.position = DEFAULT_DECORATOR_POSITION;

		setIcon(image);

		setSize(getPreferredSize());

	}

	/**
	 * @param image
	 * @param tooltip
	 */
	public BaseFigureDecorator(Image image, String tooltip)

	{

		this.position = DEFAULT_DECORATOR_POSITION;

		setIcon(image);

		setSize(getPreferredSize());

		setToolTip(new Label(tooltip));

	}

	/**
	 * @param image
	 * @param tooltip
	 * @param position
	 */
	public BaseFigureDecorator(Image image, String tooltip, int position)

	{

		this.position = position;

		setIcon(image);

		setSize(getPreferredSize());

		setToolTip(new Label(tooltip));

	}

	public Font getFont()
	{
        Font localFont = getLocalFont();
		if (localFont == null)
        {
			localFont = JFaceResources.getFontRegistry().get(
					JFaceResources.DEFAULT_FONT);
            // TODO: it's not clear that setFont is correct to call
            // here since this does a revalidate if the font changes
            // whereas the deprecated assignment to font that it replaces
            // does not
            setFont(localFont);
        }

		return localFont;
	}

	/**
	 * 
	 * @return Returns the position.
	 * 
	 */

	public int getPosition()
	{
		return position;
	}

	/**
	 * 
	 * @param position
	 * 
	 * The position to set.
	 * 
	 */

	public void setPosition(int position)
	{
		this.position = position;
	}

	/**
	 * @param tooltip
	 */
	public void setToolTipText(String tooltip)
	{
		super.setToolTip(new Label(tooltip));
	}

	/**
	 * @return the label tool tip text
	 */
	public String getToolTipText()
	{
		Label label = (Label) super.getToolTip();

		return label.getText();
	}

	/**
	 * 
	 * Sets the location of this PolygonDecoration.
	 * 
	 * 
	 * 
	 * @param p
	 * 
	 * the new location
	 * 
	 */

	public void setLocation(Point p)
	{
		bounds = null;

		location.setLocation(p);

		transform.setTranslation(p.x, p.y);
	}

	public Rectangle getBounds()
	{
		if (bounds == null)
		{
			if (prefSize == null)
			{
				getPreferredSize();
			}
			int w = prefSize.width;

			int h = prefSize.height;

			Point p = location; // transform.getTransformed(new Point(w/2,h/2));

			bounds = new Rectangle(p.x - w / 2, p.y - h / 2, w, h).getExpanded(
					w, h);
		}

		return bounds;
	}

	/**
	 * 
	 * @see org.eclipse.draw2d.Figure#useLocalCoordinates()
	 * 
	 */

	protected boolean useLocalCoordinates()
	{
		return false;
	}

	/**
	 * @param x
	 * @param y
	 */
	public void setScale(double x, double y)
	{
		// TODO: figure out how to scale images
		bounds = null;

		transform.setScale(x, y);
	}

	/**
	 * 
	 * Sets the rotation of this decoration so that the decoration points toward
	 * the
	 * 
	 * given reference point.
	 * 
	 * @param ref
	 *            the reference point
	 * 
	 * @see org.eclipse.draw2d.RotatableDecoration#setReferencePoint(org.eclipse.draw2d.geometry.Point)
	 * 
	 */

	public void setReferencePoint(Point ref)
	{
		// TODO: figure out how to rotate images
		bounds = null;
		Point pt = Point.SINGLETON;
		pt.setLocation(ref);
		pt.negate().translate(location);
		setRotation(Math.atan2(pt.y, pt.x));
	}

	/**
	 * 
	 * Sets the angle by which rotation is to be done on the PolygonDecoration.
	 * 
	 * 
	 * 
	 * @param angle
	 *            Angle of rotation
	 * 
	 * @since 2.0
	 * 
	 */

	public void setRotation(double angle)
	{
		bounds = null;

		// transform.setRotation(angle);
	}

}