/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.property;

import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.property.LengthMeta;
import org.eclipse.jst.pagedesigner.css2.value.Length;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PaddingWidthMeta
extends LengthMeta {
    private static int MIN_PADDING_THRESHOLD = 4;

    public PaddingWidthMeta() {
        super(false, "auto");
    }

    public Object calculateHTMLAttributeOverride(Element element, String htmltag, String propertyName, ICSSStyle style) {
        if ("td".equalsIgnoreCase(htmltag) || "th".equalsIgnoreCase(htmltag)) {
            Node parent = element;
            Element tableEle = null;
            while ((parent = parent.getParentNode()) != null && parent instanceof Element) {
                if (!parent.getTagName().equalsIgnoreCase("table")) continue;
                tableEle = (Element)parent;
                break;
            }
            if (tableEle != null) {
                Object length;
                String padding = DOMUtil.getAttributeIgnoreCase(tableEle, "cellpadding");
                if (padding != null && padding.trim().length() > 0 && (length = LengthMeta.toLength(padding, style, this.getPercentageType(), this.getBaseFont(style))) instanceof Length && ((Length)length).getValue() >= MIN_PADDING_THRESHOLD) {
                    return length;
                }
                return new Length(MIN_PADDING_THRESHOLD, false);
            }
        }
        return super.calculateHTMLAttributeOverride(element, htmltag, propertyName, style);
    }
}

