/* The following code was generated by JFlex 1.4.1 on 4/26/09 2:29 AM */

// *******************************************************************************
// * Copyright (c) 2005, 2009 Andrea Bittau, University College London, and others
// * All rights reserved. This program and the accompanying materials
// * are made available under the terms of the Eclipse Public License v1.0
// * which accompanies this distribution, and is available at
// * http://www.eclipse.org/legal/epl-v10.html
// *
// * Contributors:
// *     Andrea Bittau - initial API and implementation from the PsychoPath XPath 2.0 
// *******************************************************************************/


package org.eclipse.wst.xml.xpath2.processor.internal;

import java_cup.runtime.*;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1
 * on 4/26/09 2:29 AM from the specification file
 * <tt>org.eclipse.wst.xml.xpath2.processor/grammars/xpath.lex</tt>
 */
public class XPathFlex implements java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int COMMENT = 1;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\1\1\1\2\0\1\1\22\0\1\1\1\22\1\2\1\0"+
    "\1\30\2\0\1\3\1\12\1\16\1\17\1\7\1\27\1\11\1\5"+
    "\1\25\12\4\1\13\1\0\1\23\1\21\1\24\1\31\1\26\4\10"+
    "\1\6\25\10\1\14\1\0\1\15\1\0\1\10\1\0\1\42\1\45"+
    "\1\32\1\36\1\37\1\47\1\52\1\33\1\34\2\10\1\35\1\53"+
    "\1\41\1\50\1\54\1\55\1\44\1\40\1\43\1\46\1\56\1\51"+
    "\1\57\1\60\1\10\1\0\1\20\uff83\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\2\0\1\1\1\2\2\1\1\3\1\4\1\5\1\6"+
    "\1\7\1\10\1\11\1\12\1\13\1\14\1\15\1\16"+
    "\1\17\1\1\1\20\1\21\1\22\1\23\1\24\1\25"+
    "\1\26\20\5\2\2\1\0\1\27\1\0\1\27\1\30"+
    "\1\0\1\31\1\32\1\33\1\34\1\35\1\36\1\37"+
    "\1\40\1\41\4\5\1\42\1\43\1\5\1\44\1\45"+
    "\1\46\5\5\1\47\6\5\1\50\2\5\1\51\5\5"+
    "\1\52\3\5\1\53\1\54\1\55\1\56\3\5\1\57"+
    "\1\60\1\61\1\0\7\5\1\62\16\5\1\63\7\5"+
    "\1\64\1\65\4\5\1\66\1\5\1\67\2\5\1\70"+
    "\3\5\1\71\4\5\1\72\1\5\1\73\1\5\1\74"+
    "\2\5\1\75\1\76\7\5\1\77\7\5\1\100\1\101"+
    "\6\5\1\102\1\5\1\103\13\5\1\104\5\5\1\105"+
    "\1\5\1\106\3\5\1\107\4\5\1\110\10\5\1\111"+
    "\1\112\7\5\1\113\4\5\1\114\4\5\1\115\1\116"+
    "\1\5\1\117\1\120\1\121\1\5\1\122\30\5\1\123"+
    "\7\5\1\124\14\5\1\125\1\126\4\5\1\127\1\130"+
    "\1\5\1\131\4\5\1\132";

  private static int [] zzUnpackAction() {
    int [] result = new int[315];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\61\0\142\0\142\0\223\0\304\0\365\0\u0126"+
    "\0\u0157\0\142\0\142\0\u0188\0\u01b9\0\142\0\142\0\142"+
    "\0\142\0\142\0\142\0\u01ea\0\u021b\0\u024c\0\u027d\0\142"+
    "\0\142\0\142\0\142\0\u02ae\0\u02df\0\u0310\0\u0341\0\u0372"+
    "\0\u03a3\0\u03d4\0\u0405\0\u0436\0\u0467\0\u0498\0\u04c9\0\u04fa"+
    "\0\u052b\0\u055c\0\u058d\0\u05be\0\u05ef\0\223\0\u0620\0\304"+
    "\0\u0651\0\u0682\0\u06b3\0\142\0\142\0\142\0\142\0\142"+
    "\0\142\0\142\0\142\0\142\0\u06e4\0\u0715\0\u0746\0\u0777"+
    "\0\u0157\0\u07a8\0\u07d9\0\u0157\0\u0157\0\u0157\0\u080a\0\u083b"+
    "\0\u086c\0\u089d\0\u08ce\0\u0157\0\u08ff\0\u0930\0\u0961\0\u0992"+
    "\0\u09c3\0\u09f4\0\u0157\0\u0a25\0\u0a56\0\u0157\0\u0a87\0\u0ab8"+
    "\0\u0ae9\0\u0b1a\0\u0b4b\0\u0157\0\u0b7c\0\u0bad\0\u0bde\0\u0157"+
    "\0\u0157\0\u0157\0\u0157\0\u0c0f\0\u0c40\0\u0c71\0\142\0\142"+
    "\0\u0ca2\0\u0ca2\0\u0cd3\0\u0d04\0\u0d35\0\u0d66\0\u0d97\0\u0dc8"+
    "\0\u0df9\0\u0157\0\u0e2a\0\u0e5b\0\u0e8c\0\u0ebd\0\u0eee\0\u0f1f"+
    "\0\u0f50\0\u0f81\0\u0fb2\0\u0fe3\0\u1014\0\u1045\0\u1076\0\u10a7"+
    "\0\u0157\0\u10d8\0\u1109\0\u113a\0\u116b\0\u119c\0\u11cd\0\u11fe"+
    "\0\u0157\0\u0157\0\u122f\0\u1260\0\u1291\0\u12c2\0\u12f3\0\u1324"+
    "\0\u0157\0\u1355\0\u1386\0\u0157\0\u13b7\0\u13e8\0\u1419\0\u0157"+
    "\0\u144a\0\u147b\0\u14ac\0\u14dd\0\u0157\0\u150e\0\u0157\0\u153f"+
    "\0\u0157\0\u1570\0\u15a1\0\u0157\0\u0157\0\u15d2\0\u1603\0\u1634"+
    "\0\u1665\0\u1696\0\u16c7\0\u16f8\0\u0157\0\u1729\0\u175a\0\u178b"+
    "\0\u17bc\0\u17ed\0\u181e\0\u184f\0\u0157\0\u0157\0\u1880\0\u18b1"+
    "\0\u18e2\0\u1913\0\u1944\0\u1975\0\u0157\0\u19a6\0\u0157\0\u19d7"+
    "\0\u1a08\0\u1a39\0\u1a6a\0\u1a9b\0\u1acc\0\u1afd\0\u1b2e\0\u1b5f"+
    "\0\u1b90\0\u1bc1\0\u0157\0\u1bf2\0\u1c23\0\u1c54\0\u1c85\0\u1cb6"+
    "\0\u0157\0\u1ce7\0\u0157\0\u1d18\0\u1d49\0\u1d7a\0\u0157\0\u1dab"+
    "\0\u1ddc\0\u1e0d\0\u1e3e\0\u0157\0\u1e6f\0\u1ea0\0\u1ed1\0\u1f02"+
    "\0\u1f33\0\u1f64\0\u1f95\0\u1fc6\0\u0157\0\u0157\0\u1ff7\0\u2028"+
    "\0\u2059\0\u208a\0\u20bb\0\u20ec\0\u211d\0\u214e\0\u217f\0\u21b0"+
    "\0\u21e1\0\u2212\0\u0157\0\u2243\0\u2274\0\u22a5\0\u22d6\0\u0157"+
    "\0\u0157\0\u2307\0\u0157\0\u2338\0\u2369\0\u239a\0\u23cb\0\u23fc"+
    "\0\u242d\0\u245e\0\u248f\0\u24c0\0\u24f1\0\u2522\0\u2553\0\u2584"+
    "\0\u25b5\0\u25e6\0\u2617\0\u2648\0\u2679\0\u26aa\0\u26db\0\u270c"+
    "\0\u273d\0\u276e\0\u279f\0\u27d0\0\u2801\0\u2832\0\u2863\0\u0157"+
    "\0\u2894\0\u28c5\0\u28f6\0\u2927\0\u2958\0\u2989\0\u29ba\0\u0157"+
    "\0\u29eb\0\u2a1c\0\u2a4d\0\u2a7e\0\u2aaf\0\u2ae0\0\u2b11\0\u2b42"+
    "\0\u2b73\0\u2ba4\0\u2bd5\0\u2c06\0\u0157\0\u0157\0\u2c37\0\u2c68"+
    "\0\u2c99\0\u2cca\0\u0157\0\u0157\0\u2cfb\0\u0157\0\u2d2c\0\u2d5d"+
    "\0\u2d8e\0\u2dbf\0\u0157";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[315];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\3\1\4\1\5\1\6\1\7\1\10\1\11\1\12"+
    "\1\11\1\13\1\14\1\15\1\16\1\17\1\20\1\21"+
    "\1\22\1\23\1\24\1\25\1\26\1\27\1\30\1\31"+
    "\1\32\1\33\1\34\1\11\1\35\1\36\1\37\1\40"+
    "\1\41\1\42\1\43\1\44\1\45\1\11\1\46\1\47"+
    "\1\50\1\11\1\51\1\52\1\53\4\11\12\4\1\54"+
    "\1\55\45\4\61\0\2\56\1\57\56\56\3\60\1\61"+
    "\55\60\4\0\1\7\1\62\1\63\30\0\1\63\25\0"+
    "\1\62\1\64\57\0\3\11\1\0\2\11\20\0\27\11"+
    "\13\0\1\65\60\0\1\66\66\0\1\67\60\0\1\70"+
    "\1\0\1\71\56\0\1\72\2\0\1\73\61\0\1\74"+
    "\37\0\3\11\1\0\2\11\20\0\1\11\1\75\6\11"+
    "\1\76\5\11\1\77\10\11\4\0\3\11\1\0\2\11"+
    "\20\0\4\11\1\100\1\11\1\101\1\102\1\11\1\103"+
    "\3\11\1\104\11\11\4\0\3\11\1\0\2\11\20\0"+
    "\5\11\1\105\3\11\1\106\15\11\4\0\3\11\1\0"+
    "\2\11\20\0\2\11\1\107\2\11\1\110\10\11\1\111"+
    "\10\11\4\0\3\11\1\0\2\11\20\0\3\11\1\112"+
    "\15\11\1\113\1\11\1\114\1\115\1\116\1\11\4\0"+
    "\3\11\1\0\2\11\20\0\1\117\4\11\1\120\2\11"+
    "\1\121\5\11\1\122\10\11\4\0\3\11\1\0\2\11"+
    "\20\0\5\11\1\123\2\11\1\124\5\11\1\125\10\11"+
    "\4\0\3\11\1\0\2\11\20\0\6\11\1\126\1\127"+
    "\1\11\1\130\15\11\4\0\3\11\1\0\2\11\20\0"+
    "\1\11\1\131\3\11\1\132\4\11\1\133\3\11\1\134"+
    "\10\11\4\0\3\11\1\0\2\11\20\0\5\11\1\135"+
    "\21\11\4\0\3\11\1\0\2\11\20\0\7\11\1\136"+
    "\17\11\4\0\3\11\1\0\2\11\20\0\16\11\1\137"+
    "\10\11\4\0\3\11\1\0\2\11\20\0\12\11\1\140"+
    "\2\11\1\141\11\11\4\0\3\11\1\0\2\11\20\0"+
    "\5\11\1\142\3\11\1\143\15\11\4\0\3\11\1\0"+
    "\2\11\20\0\16\11\1\144\10\11\4\0\3\11\1\0"+
    "\2\11\20\0\10\11\1\145\1\11\1\146\14\11\13\0"+
    "\1\147\63\0\1\150\44\0\1\56\61\0\1\60\61\0"+
    "\1\62\1\0\1\63\30\0\1\63\25\0\1\151\2\0"+
    "\1\152\1\0\1\152\53\0\3\11\1\0\2\11\20\0"+
    "\2\11\1\153\24\11\4\0\3\11\1\0\2\11\20\0"+
    "\6\11\1\154\20\11\4\0\3\11\1\0\2\11\20\0"+
    "\21\11\1\155\5\11\4\0\3\11\1\0\2\11\20\0"+
    "\2\11\1\156\24\11\4\0\3\11\1\0\2\11\20\0"+
    "\6\11\1\157\2\11\1\160\15\11\4\0\3\11\1\0"+
    "\2\11\20\0\5\11\1\161\21\11\4\0\3\11\1\0"+
    "\2\11\20\0\24\11\1\162\2\11\4\0\3\11\1\0"+
    "\2\11\20\0\6\11\1\163\20\11\4\0\3\11\1\0"+
    "\2\11\20\0\1\164\26\11\4\0\3\11\1\0\2\11"+
    "\20\0\5\11\1\165\1\166\20\11\4\0\3\11\1\0"+
    "\2\11\20\0\22\11\1\167\4\11\4\0\3\11\1\0"+
    "\2\11\20\0\5\11\1\170\21\11\4\0\3\11\1\0"+
    "\2\11\20\0\1\171\26\11\4\0\3\11\1\0\2\11"+
    "\20\0\1\11\1\172\25\11\4\0\3\11\1\0\2\11"+
    "\20\0\3\11\1\173\23\11\4\0\3\11\1\0\2\11"+
    "\20\0\11\11\1\174\15\11\4\0\3\11\1\0\2\11"+
    "\20\0\21\11\1\175\5\11\4\0\3\11\1\0\2\11"+
    "\20\0\21\11\1\176\5\11\4\0\3\11\1\0\2\11"+
    "\20\0\4\11\1\177\22\11\4\0\3\11\1\0\2\11"+
    "\20\0\1\200\3\11\1\201\22\11\4\0\3\11\1\0"+
    "\2\11\20\0\11\11\1\202\15\11\4\0\3\11\1\0"+
    "\2\11\20\0\5\11\1\203\21\11\4\0\3\11\1\0"+
    "\2\11\20\0\25\11\1\204\1\11\4\0\3\11\1\0"+
    "\2\11\20\0\5\11\1\205\21\11\4\0\3\11\1\0"+
    "\2\11\20\0\11\11\1\206\15\11\4\0\3\11\1\0"+
    "\2\11\20\0\2\11\1\207\24\11\4\0\3\11\1\0"+
    "\2\11\20\0\3\11\1\210\6\11\1\211\14\11\4\0"+
    "\3\11\1\0\2\11\20\0\4\11\1\212\22\11\4\0"+
    "\3\11\1\0\2\11\20\0\12\11\1\213\14\11\4\0"+
    "\3\11\1\0\2\11\20\0\5\11\1\214\10\11\1\215"+
    "\10\11\4\0\1\151\60\0\3\11\1\0\2\11\20\0"+
    "\3\11\1\216\23\11\4\0\3\11\1\0\2\11\20\0"+
    "\11\11\1\217\15\11\4\0\3\11\1\0\2\11\20\0"+
    "\21\11\1\220\5\11\4\0\3\11\1\0\2\11\20\0"+
    "\24\11\1\221\2\11\4\0\3\11\1\0\2\11\20\0"+
    "\11\11\1\222\15\11\4\0\3\11\1\0\2\11\20\0"+
    "\5\11\1\223\21\11\4\0\3\11\1\0\2\11\20\0"+
    "\21\11\1\224\5\11\4\0\3\11\1\0\2\11\20\0"+
    "\1\225\26\11\4\0\3\11\1\0\2\11\20\0\14\11"+
    "\1\226\12\11\4\0\3\11\1\0\2\11\20\0\21\11"+
    "\1\227\5\11\4\0\3\11\1\0\2\11\20\0\5\11"+
    "\1\230\21\11\4\0\3\11\1\0\2\11\20\0\11\11"+
    "\1\231\15\11\4\0\3\11\1\0\2\11\20\0\12\11"+
    "\1\232\14\11\4\0\3\11\1\0\2\11\20\0\5\11"+
    "\1\233\21\11\4\0\3\11\1\0\2\11\20\0\5\11"+
    "\1\234\21\11\4\0\3\11\1\0\2\11\20\0\15\11"+
    "\1\235\11\11\4\0\3\11\1\0\2\11\20\0\2\11"+
    "\1\236\24\11\4\0\3\11\1\0\2\11\20\0\5\11"+
    "\1\237\21\11\4\0\3\11\1\0\2\11\20\0\5\11"+
    "\1\240\21\11\4\0\3\11\1\0\2\11\20\0\5\11"+
    "\1\241\21\11\4\0\3\11\1\0\2\11\20\0\5\11"+
    "\1\242\21\11\4\0\3\11\1\0\2\11\20\0\12\11"+
    "\1\243\14\11\4\0\3\11\1\0\2\11\20\0\7\11"+
    "\1\244\17\11\4\0\3\11\1\0\2\11\20\0\11\11"+
    "\1\245\15\11\4\0\3\11\1\0\2\11\20\0\10\11"+
    "\1\246\16\11\4\0\3\11\1\0\2\11\20\0\14\11"+
    "\1\247\12\11\4\0\3\11\1\0\2\11\20\0\16\11"+
    "\1\250\10\11\4\0\3\11\1\0\2\11\20\0\3\11"+
    "\1\251\23\11\4\0\3\11\1\0\2\11\20\0\5\11"+
    "\1\252\21\11\4\0\3\11\1\0\2\11\20\0\1\253"+
    "\26\11\4\0\3\11\1\0\2\11\20\0\1\254\26\11"+
    "\4\0\3\11\1\0\2\11\20\0\4\11\1\255\22\11"+
    "\4\0\3\11\1\0\2\11\20\0\10\11\1\256\16\11"+
    "\4\0\3\11\1\0\2\11\20\0\5\11\1\257\21\11"+
    "\4\0\3\11\1\0\2\11\20\0\10\11\1\260\16\11"+
    "\4\0\3\11\1\0\2\11\20\0\12\11\1\261\14\11"+
    "\4\0\3\11\1\0\2\11\20\0\5\11\1\262\21\11"+
    "\4\0\3\11\1\0\2\11\20\0\21\11\1\263\5\11"+
    "\4\0\3\11\1\0\2\11\20\0\5\11\1\264\21\11"+
    "\4\0\3\11\1\0\2\11\20\0\26\11\1\265\4\0"+
    "\3\11\1\0\2\11\20\0\26\11\1\266\4\0\3\11"+
    "\1\0\2\11\20\0\22\11\1\267\4\11\4\0\3\11"+
    "\1\0\2\11\20\0\21\11\1\270\5\11\4\0\3\11"+
    "\1\0\2\11\20\0\6\11\1\271\20\11\4\0\3\11"+
    "\1\0\2\11\20\0\6\11\1\272\20\11\4\0\3\11"+
    "\1\0\2\11\20\0\6\11\1\273\20\11\4\0\3\11"+
    "\1\0\2\11\20\0\2\11\1\274\24\11\4\0\3\11"+
    "\1\0\2\11\20\0\11\11\1\275\15\11\4\0\3\11"+
    "\1\0\2\11\20\0\12\11\1\276\14\11\4\0\3\11"+
    "\1\0\2\11\20\0\7\11\1\277\17\11\4\0\3\11"+
    "\1\0\2\11\20\0\16\11\1\300\10\11\4\0\3\11"+
    "\1\0\2\11\20\0\7\11\1\301\17\11\4\0\3\11"+
    "\1\0\2\11\20\0\5\11\1\302\21\11\4\0\3\11"+
    "\1\0\2\11\20\0\5\11\1\303\21\11\4\0\3\11"+
    "\1\0\2\11\20\0\13\11\1\304\13\11\4\0\3\11"+
    "\1\0\2\11\20\0\7\11\1\305\17\11\4\0\3\11"+
    "\1\0\2\11\20\0\7\11\1\306\17\11\4\0\3\11"+
    "\1\0\2\11\20\0\6\11\1\307\20\11\4\0\3\11"+
    "\1\0\2\11\20\0\7\11\1\310\17\11\4\0\3\11"+
    "\1\0\2\11\20\0\5\11\1\311\21\11\4\0\3\11"+
    "\1\0\2\11\20\0\7\11\1\312\17\11\4\0\3\11"+
    "\1\0\2\11\20\0\11\11\1\313\15\11\4\0\3\11"+
    "\1\0\2\11\20\0\10\11\1\314\16\11\4\0\3\11"+
    "\1\0\2\11\20\0\15\11\1\315\11\11\4\0\3\11"+
    "\1\0\2\11\20\0\22\11\1\316\4\11\4\0\3\11"+
    "\1\0\2\11\20\0\11\11\1\317\15\11\4\0\3\11"+
    "\1\0\2\11\20\0\13\11\1\320\13\11\4\0\3\11"+
    "\1\0\2\11\20\0\7\11\1\321\17\11\4\0\3\11"+
    "\1\0\2\11\20\0\17\11\1\322\7\11\4\0\3\11"+
    "\1\0\2\11\20\0\11\11\1\323\15\11\4\0\3\11"+
    "\1\0\2\11\20\0\4\11\1\324\22\11\4\0\3\11"+
    "\1\0\2\11\20\0\6\11\1\325\20\11\4\0\3\11"+
    "\1\0\2\11\20\0\3\11\1\326\23\11\4\0\3\11"+
    "\1\0\2\11\20\0\11\11\1\327\15\11\4\0\3\11"+
    "\1\0\2\11\20\0\1\330\26\11\4\0\3\11\1\0"+
    "\2\11\20\0\5\11\1\331\21\11\4\0\3\11\1\0"+
    "\2\11\20\0\4\11\1\332\22\11\4\0\3\11\1\0"+
    "\2\11\20\0\7\11\1\333\17\11\4\0\3\11\1\0"+
    "\2\11\20\0\11\11\1\334\15\11\4\0\3\11\1\0"+
    "\1\11\1\335\20\0\27\11\4\0\3\11\1\0\2\11"+
    "\20\0\2\11\1\336\24\11\4\0\3\11\1\0\2\11"+
    "\20\0\10\11\1\337\16\11\4\0\3\11\1\0\2\11"+
    "\20\0\16\11\1\340\10\11\4\0\3\11\1\0\2\11"+
    "\20\0\14\11\1\341\12\11\4\0\3\11\1\0\2\11"+
    "\20\0\2\11\1\342\24\11\4\0\3\11\1\0\2\11"+
    "\20\0\2\11\1\343\24\11\4\0\3\11\1\0\2\11"+
    "\20\0\6\11\1\344\20\11\4\0\3\11\1\0\2\11"+
    "\20\0\5\11\1\345\21\11\4\0\3\11\1\0\2\11"+
    "\20\0\5\11\1\346\21\11\4\0\3\11\1\0\2\11"+
    "\20\0\1\347\26\11\4\0\3\11\1\0\2\11\20\0"+
    "\10\11\1\350\16\11\4\0\3\11\1\0\2\11\20\0"+
    "\11\11\1\351\15\11\4\0\3\11\1\0\2\11\20\0"+
    "\5\11\1\352\2\11\1\353\16\11\4\0\3\11\1\0"+
    "\2\11\20\0\5\11\1\354\21\11\4\0\3\11\1\0"+
    "\2\11\20\0\1\355\26\11\4\0\3\11\1\0\2\11"+
    "\20\0\12\11\1\356\14\11\4\0\3\11\1\0\2\11"+
    "\20\0\11\11\1\357\15\11\4\0\3\11\1\0\2\11"+
    "\20\0\7\11\1\360\17\11\4\0\3\11\1\0\2\11"+
    "\20\0\7\11\1\361\17\11\4\0\3\11\1\0\2\11"+
    "\20\0\2\11\1\362\24\11\4\0\3\11\1\0\2\11"+
    "\20\0\11\11\1\363\15\11\4\0\3\11\1\0\2\11"+
    "\20\0\7\11\1\364\17\11\4\0\3\11\1\0\1\11"+
    "\1\365\20\0\27\11\4\0\3\11\1\0\2\11\20\0"+
    "\3\11\1\366\23\11\4\0\3\11\1\0\2\11\20\0"+
    "\11\11\1\367\15\11\4\0\3\11\1\0\2\11\20\0"+
    "\6\11\1\370\20\11\4\0\3\11\1\0\2\11\20\0"+
    "\5\11\1\371\21\11\4\0\3\11\1\0\1\11\1\372"+
    "\20\0\27\11\4\0\3\11\1\0\2\11\20\0\5\11"+
    "\1\373\21\11\4\0\3\11\1\0\2\11\20\0\20\11"+
    "\1\374\6\11\4\0\3\11\1\0\2\11\20\0\20\11"+
    "\1\375\6\11\4\0\3\11\1\0\2\11\20\0\7\11"+
    "\1\376\17\11\4\0\3\11\1\0\2\11\20\0\11\11"+
    "\1\377\15\11\4\0\3\11\1\0\2\11\20\0\7\11"+
    "\1\u0100\17\11\4\0\3\11\1\0\2\11\20\0\5\11"+
    "\1\u0101\21\11\4\0\3\11\1\0\2\11\20\0\11\11"+
    "\1\u0102\15\11\4\0\3\11\1\0\2\11\20\0\16\11"+
    "\1\u0103\10\11\4\0\3\11\1\0\1\11\1\u0104\20\0"+
    "\27\11\4\0\3\11\1\0\1\11\1\u0105\20\0\27\11"+
    "\4\0\3\11\1\0\2\11\20\0\20\11\1\u0106\6\11"+
    "\4\0\3\11\1\0\1\11\1\u0107\20\0\27\11\4\0"+
    "\3\11\1\0\2\11\20\0\16\11\1\u0108\10\11\4\0"+
    "\3\11\1\0\2\11\20\0\21\11\1\u0109\5\11\4\0"+
    "\3\11\1\0\2\11\20\0\12\11\1\u010a\14\11\4\0"+
    "\3\11\1\0\2\11\20\0\12\11\1\u010b\14\11\4\0"+
    "\3\11\1\0\2\11\20\0\6\11\1\u010c\20\11\4\0"+
    "\3\11\1\0\2\11\20\0\6\11\1\u010d\20\11\4\0"+
    "\3\11\1\0\1\11\1\u010e\20\0\27\11\4\0\3\11"+
    "\1\0\2\11\20\0\16\11\1\u010f\10\11\4\0\3\11"+
    "\1\0\2\11\20\0\4\11\1\u0110\22\11\4\0\3\11"+
    "\1\0\2\11\20\0\5\11\1\u0111\21\11\4\0\3\11"+
    "\1\0\2\11\20\0\2\11\1\u0112\24\11\4\0\3\11"+
    "\1\0\1\11\1\u0113\20\0\27\11\4\0\3\11\1\0"+
    "\2\11\20\0\2\11\1\u0114\24\11\4\0\3\11\1\0"+
    "\2\11\20\0\2\11\1\u0115\24\11\4\0\3\11\1\0"+
    "\2\11\20\0\2\11\1\u0116\24\11\4\0\3\11\1\0"+
    "\2\11\20\0\12\11\1\u0117\14\11\4\0\3\11\1\0"+
    "\2\11\20\0\5\11\1\u0118\21\11\4\0\3\11\1\0"+
    "\2\11\20\0\7\11\1\u0119\17\11\4\0\3\11\1\0"+
    "\2\11\20\0\13\11\1\u011a\13\11\4\0\3\11\1\0"+
    "\2\11\20\0\6\11\1\u011b\20\11\4\0\3\11\1\0"+
    "\2\11\20\0\13\11\1\u011c\13\11\4\0\3\11\1\0"+
    "\2\11\20\0\13\11\1\u011d\13\11\4\0\3\11\1\0"+
    "\2\11\20\0\7\11\1\u011e\17\11\4\0\3\11\1\0"+
    "\1\11\1\u011f\20\0\27\11\4\0\3\11\1\0\2\11"+
    "\20\0\11\11\1\u0120\15\11\4\0\3\11\1\0\2\11"+
    "\20\0\14\11\1\u0121\12\11\4\0\3\11\1\0\2\11"+
    "\20\0\5\11\1\u0122\21\11\4\0\3\11\1\0\2\11"+
    "\20\0\3\11\1\u0123\23\11\4\0\3\11\1\0\2\11"+
    "\20\0\3\11\1\u0124\23\11\4\0\3\11\1\0\2\11"+
    "\20\0\6\11\1\u0125\20\11\4\0\3\11\1\0\2\11"+
    "\20\0\6\11\1\u0126\20\11\4\0\3\11\1\0\2\11"+
    "\20\0\11\11\1\u0127\15\11\4\0\3\11\1\0\2\11"+
    "\20\0\3\11\1\u0128\23\11\4\0\3\11\1\0\2\11"+
    "\20\0\2\11\1\u0129\24\11\4\0\3\11\1\0\2\11"+
    "\20\0\2\11\1\u012a\24\11\4\0\3\11\1\0\2\11"+
    "\20\0\11\11\1\u012b\15\11\4\0\3\11\1\0\2\11"+
    "\20\0\5\11\1\u012c\21\11\4\0\3\11\1\0\2\11"+
    "\20\0\5\11\1\u012d\21\11\4\0\3\11\1\0\2\11"+
    "\20\0\15\11\1\u012e\11\11\4\0\3\11\1\0\2\11"+
    "\20\0\7\11\1\u012f\17\11\4\0\3\11\1\0\2\11"+
    "\20\0\7\11\1\u0130\17\11\4\0\3\11\1\0\2\11"+
    "\20\0\12\11\1\u0131\14\11\4\0\3\11\1\0\2\11"+
    "\20\0\3\11\1\u0132\23\11\4\0\3\11\1\0\2\11"+
    "\20\0\20\11\1\u0133\6\11\4\0\3\11\1\0\2\11"+
    "\20\0\20\11\1\u0134\6\11\4\0\3\11\1\0\2\11"+
    "\20\0\14\11\1\u0135\12\11\4\0\3\11\1\0\2\11"+
    "\20\0\15\11\1\u0136\11\11\4\0\3\11\1\0\2\11"+
    "\20\0\1\u0137\26\11\4\0\3\11\1\0\2\11\20\0"+
    "\11\11\1\u0138\15\11\4\0\3\11\1\0\2\11\20\0"+
    "\2\11\1\u0139\24\11\4\0\3\11\1\0\2\11\20\0"+
    "\16\11\1\u013a\10\11\4\0\3\11\1\0\2\11\20\0"+
    "\7\11\1\u013b\17\11";

  private static int [] zzUnpackTrans() {
    int [] result = new int[11760];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\2\0\2\11\5\1\2\11\2\1\6\11\4\1\4\11"+
    "\22\1\1\0\1\1\1\0\2\1\1\0\11\11\52\1"+
    "\2\11\1\1\1\0\321\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[315];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
	public int lineno() { return yyline + 1; }
	public int colno() { return yycolumn + 1; }

	private Symbol symbol(int type) {
		return new Symbol(type, lineno(), colno());
	}
	private Symbol symbol(int type, Object value) {
		return new Symbol(type, lineno(), colno(), value);
	}

	private int commentLevel = 0;


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public XPathFlex(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public XPathFlex(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 132) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn++;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 75: 
          { return symbol(sym.ANCESTOR);
          }
        case 91: break;
        case 56: 
          { return symbol(sym.ITEM);
          }
        case 92: break;
        case 46: 
          { return symbol(sym.GT);
          }
        case 93: break;
        case 82: 
          { return symbol(sym.DESCENDANT);
          }
        case 94: break;
        case 15: 
          { return symbol(sym.EQUALS);
          }
        case 95: break;
        case 39: 
          { return symbol(sym.EQ);
          }
        case 96: break;
        case 72: 
          { return symbol(sym.ELEMENT);
          }
        case 97: break;
        case 78: 
          { return symbol(sym.NAMESPACE);
          }
        case 98: break;
        case 34: 
          { return symbol(sym.IS);
          }
        case 99: break;
        case 1: 
          { String err = "Unknown character at line " + lineno(); 
		err += " col " + colno();
		err += ": " + yytext(); 
			     
		throw new JFlexError(err);
          }
        case 100: break;
        case 3: 
          { return symbol(sym.INTEGER, new Integer(yytext()));
          }
        case 101: break;
        case 20: 
          { return symbol(sym.COMMA);
          }
        case 102: break;
        case 71: 
          { return symbol(sym.COMMENT);
          }
        case 103: break;
        case 38: 
          { return symbol(sym.LT);
          }
        case 104: break;
        case 30: 
          { return symbol(sym.LESS_LESS);
          }
        case 105: break;
        case 66: 
          { return symbol(sym.TREAT);
          }
        case 106: break;
        case 13: 
          { return symbol(sym.STAR);
          }
        case 107: break;
        case 67: 
          { return symbol(sym.UNION);
          }
        case 108: break;
        case 21: 
          { return symbol(sym.DOLLAR);
          }
        case 109: break;
        case 84: 
          { return symbol(sym.SCHEMA_ELEMENT);
          }
        case 110: break;
        case 35: 
          { return symbol(sym.IN);
          }
        case 111: break;
        case 43: 
          { return symbol(sym.OR);
          }
        case 112: break;
        case 25: 
          { return symbol(sym.DOTDOT);
          }
        case 113: break;
        case 64: 
          { return symbol(sym.EMPTY);
          }
        case 114: break;
        case 5: 
          { return symbol(sym.NCNAME, yytext());
          }
        case 115: break;
        case 19: 
          { return symbol(sym.AT_SYM);
          }
        case 116: break;
        case 29: 
          { return symbol(sym.LESSEQUAL);
          }
        case 117: break;
        case 26: 
          { commentLevel++; // int overflow =P
			  yybegin(COMMENT);
          }
        case 118: break;
        case 83: 
          { return symbol(sym.DOCUMENT_NODE);
          }
        case 119: break;
        case 33: 
          { return symbol(sym.FORWARD_SLASHSLASH);
          }
        case 120: break;
        case 18: 
          { return symbol(sym.FORWARD_SLASH);
          }
        case 121: break;
        case 68: 
          { return symbol(sym.EXCEPT);
          }
        case 122: break;
        case 88: 
          { return symbol(sym.PRECEDING_SIBLING);
          }
        case 123: break;
        case 74: 
          { return symbol(sym.INSTANCE);
          }
        case 124: break;
        case 57: 
          { return symbol(sym.ELSE);
          }
        case 125: break;
        case 45: 
          { return symbol(sym.GE);
          }
        case 126: break;
        case 47: 
          { commentLevel++;
          }
        case 127: break;
        case 36: 
          { return symbol(sym.IF);
          }
        case 128: break;
        case 42: 
          { return symbol(sym.TO);
          }
        case 129: break;
        case 81: 
          { return symbol(sym.PRECEDING);
          }
        case 130: break;
        case 31: 
          { return symbol(sym.GREATEREQUAL);
          }
        case 131: break;
        case 86: 
          { return symbol(sym.ANCESTOR_OR_SELF);
          }
        case 132: break;
        case 24: 
          { return symbol(sym.DECIMAL, new Double(yytext()));
          }
        case 133: break;
        case 79: 
          { return symbol(sym.ATTRIBUTE);
          }
        case 134: break;
        case 85: 
          { return symbol(sym.SCHEMA_ATTRIBUTE);
          }
        case 135: break;
        case 80: 
          { return symbol(sym.FOLLOWING);
          }
        case 136: break;
        case 52: 
          { return symbol(sym.FOR);
          }
        case 137: break;
        case 14: 
          { return symbol(sym.PIPE);
          }
        case 138: break;
        case 22: 
          { return symbol(sym.QUESTIONMARK);
          }
        case 139: break;
        case 37: 
          { return symbol(sym.LE);
          }
        case 140: break;
        case 76: 
          { return symbol(sym.INTERSECT);
          }
        case 141: break;
        case 48: 
          { commentLevel--; 
			  if(commentLevel == 0)
		          	yybegin(YYINITIAL);
          }
        case 142: break;
        case 44: 
          { return symbol(sym.OF);
          }
        case 143: break;
        case 63: 
          { return symbol(sym.CHILD);
          }
        case 144: break;
        case 40: 
          { return symbol(sym.NE);
          }
        case 145: break;
        case 58: 
          { return symbol(sym.SELF);
          }
        case 146: break;
        case 27: 
          { return symbol(sym.COLONCOLON);
          }
        case 147: break;
        case 50: 
          { return symbol(sym.DIV);
          }
        case 148: break;
        case 87: 
          { return symbol(sym.FOLLOWING_SIBLING);
          }
        case 149: break;
        case 62: 
          { return symbol(sym.TEXT);
          }
        case 150: break;
        case 69: 
          { return symbol(sym.RETURN);
          }
        case 151: break;
        case 53: 
          { return symbol(sym.MOD);
          }
        case 152: break;
        case 6: 
          { return symbol(sym.PLUS);
          }
        case 153: break;
        case 28: 
          { return symbol(sym.NOTEQUALS);
          }
        case 154: break;
        case 32: 
          { return symbol(sym.GREATER_GREATER);
          }
        case 155: break;
        case 65: 
          { return symbol(sym.EVERY);
          }
        case 156: break;
        case 73: 
          { return symbol(sym.CASTABLE);
          }
        case 157: break;
        case 89: 
          { return symbol(sym.DESCENDANT_OR_SELF);
          }
        case 158: break;
        case 23: 
          { // get rid of quotes
				String str = yytext();
				assert str.length() >= 2;
				str = str.substring(1,str.length()-1);
				return symbol(sym.STRING, str);
          }
        case 159: break;
        case 77: 
          { return symbol(sym.SATISFIES);
          }
        case 160: break;
        case 90: 
          { return symbol(sym.PROCESSING_INSTRUCTION);
          }
        case 161: break;
        case 16: 
          { return symbol(sym.LESSTHAN);
          }
        case 162: break;
        case 54: 
          { return symbol(sym.CAST);
          }
        case 163: break;
        case 12: 
          { return symbol(sym.RPAR);
          }
        case 164: break;
        case 2: 
          { /* ignore */
          }
        case 165: break;
        case 10: 
          { return symbol(sym.LBRACKET);
          }
        case 166: break;
        case 60: 
          { return symbol(sym.NODE);
          }
        case 167: break;
        case 55: 
          { return symbol(sym.IDIV);
          }
        case 168: break;
        case 49: 
          { return symbol(sym.DOUBLE, new Double(yytext()));
          }
        case 169: break;
        case 61: 
          { return symbol(sym.THEN);
          }
        case 170: break;
        case 59: 
          { return symbol(sym.SOME);
          }
        case 171: break;
        case 70: 
          { return symbol(sym.PARENT);
          }
        case 172: break;
        case 7: 
          { return symbol(sym.MINUS);
          }
        case 173: break;
        case 41: 
          { return symbol(sym.AS);
          }
        case 174: break;
        case 4: 
          { return symbol(sym.DOT);
          }
        case 175: break;
        case 11: 
          { return symbol(sym.RBRACKET);
          }
        case 176: break;
        case 17: 
          { return symbol(sym.GREATER);
          }
        case 177: break;
        case 51: 
          { return symbol(sym.AND);
          }
        case 178: break;
        case 8: 
          { return symbol(sym.LPAR);
          }
        case 179: break;
        case 9: 
          { return symbol(sym.COLON);
          }
        case 180: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
              { return new java_cup.runtime.Symbol(sym.EOF); }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
