/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpGt;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpLt;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CtrType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;

public class XSBoolean
extends CtrType
implements CmpEq,
CmpGt,
CmpLt {
    private boolean _value;

    public XSBoolean(boolean x) {
        this._value = x;
    }

    public XSBoolean() {
        this(false);
    }

    public String string_type() {
        return "xs:boolean";
    }

    public String type_name() {
        return "boolean";
    }

    public String string_value() {
        return "" + this._value;
    }

    public boolean value() {
        return this._value;
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        Boolean b = new Boolean(aat.string_value());
        rs.add(new XSBoolean(b));
        return rs;
    }

    public boolean eq(AnyType arg) throws DynamicError {
        XSBoolean barg = (XSBoolean)NumericType.get_single_type(arg, XSBoolean.class);
        return this.value() == barg.value();
    }

    public boolean gt(AnyType arg) throws DynamicError {
        XSBoolean barg = (XSBoolean)NumericType.get_single_type(arg, XSBoolean.class);
        boolean result = false;
        if (this.value() && !barg.value()) {
            result = true;
        }
        return result;
    }

    public boolean lt(AnyType arg) throws DynamicError {
        XSBoolean barg = (XSBoolean)NumericType.get_single_type(arg, XSBoolean.class);
        boolean result = false;
        if (!this.value() && barg.value()) {
            result = true;
        }
        return result;
    }
}

