/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpGt;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpLt;
import org.eclipse.wst.xml.xpath2.processor.internal.function.MathMinus;
import org.eclipse.wst.xml.xpath2.processor.internal.function.MathPlus;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CalendarType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XDTDayTimeDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XDTYearMonthDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDateTime;

public class XSDate
extends CalendarType
implements CmpEq,
CmpLt,
CmpGt,
MathMinus,
MathPlus,
Cloneable {
    private Calendar _calendar;
    private boolean _timezoned;
    private XDTDayTimeDuration _tz;

    public XSDate(Calendar cal, XDTDayTimeDuration tz) {
        this._calendar = cal;
        this._tz = tz;
        this._timezoned = tz != null;
    }

    public XSDate() {
        this(new GregorianCalendar(), null);
    }

    public String type_name() {
        return "date";
    }

    public Object clone() throws CloneNotSupportedException {
        Calendar c = (Calendar)this.calendar().clone();
        XDTDayTimeDuration t = this.tz();
        if (t != null) {
            t = (XDTDayTimeDuration)t.clone();
        }
        return new XSDate(c, t);
    }

    public static XSDate parse_date(String str) {
        String lame = "";
        String lame2 = "T00:00:00.0";
        int index = str.indexOf(43, 1);
        if (index == -1) {
            index = str.indexOf(45, 1);
            if (index == -1) {
                return null;
            }
            if ((index = str.indexOf(45, index + 1)) == -1) {
                return null;
            }
            index = str.indexOf(45, index + 1);
        }
        if (index == -1) {
            index = str.indexOf(90, 1);
        }
        if (index != -1) {
            lame = str.substring(0, index);
            lame = String.valueOf(lame) + lame2;
            lame = String.valueOf(lame) + str.substring(index, str.length());
        } else {
            lame = String.valueOf(str) + lame2;
        }
        XSDateTime dt = XSDateTime.parseDateTime(lame);
        if (dt == null) {
            return null;
        }
        return new XSDate(dt.calendar(), dt.tz());
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        XSDate dt = XSDate.parse_date(aat.string_value());
        if (dt == null) {
            throw DynamicError.cant_cast(null);
        }
        rs.add(dt);
        return rs;
    }

    public int year() {
        int y = this._calendar.get(1);
        if (this._calendar.get(0) == 0) {
            y *= -1;
        }
        return y;
    }

    public int month() {
        return this._calendar.get(2) + 1;
    }

    public int day() {
        return this._calendar.get(5);
    }

    public boolean timezoned() {
        return this._timezoned;
    }

    public String string_value() {
        String ret = "";
        ret = String.valueOf(ret) + XSDateTime.pad_int(this.year(), 4);
        ret = String.valueOf(ret) + "-";
        ret = String.valueOf(ret) + XSDateTime.pad_int(this.month(), 2);
        ret = String.valueOf(ret) + "-";
        ret = String.valueOf(ret) + XSDateTime.pad_int(this.day(), 2);
        if (this.timezoned()) {
            ret = String.valueOf(ret) + "Z";
        }
        return ret;
    }

    public String string_type() {
        return "xs:date";
    }

    public Calendar calendar() {
        return this._calendar;
    }

    public XDTDayTimeDuration tz() {
        return this._tz;
    }

    public boolean eq(AnyType arg) throws DynamicError {
        XSDate val = (XSDate)NumericType.get_single_type(arg, XSDate.class);
        return this.calendar().equals(val.calendar());
    }

    public boolean lt(AnyType arg) throws DynamicError {
        XSDate val = (XSDate)NumericType.get_single_type(arg, XSDate.class);
        return this.calendar().before(val.calendar());
    }

    public boolean gt(AnyType arg) throws DynamicError {
        XSDate val = (XSDate)NumericType.get_single_type(arg, XSDate.class);
        return this.calendar().after(val.calendar());
    }

    public double value() {
        return (double)this.calendar().getTimeInMillis() / 1000.0;
    }

    public ResultSequence minus(ResultSequence arg) throws DynamicError {
        if (arg.size() != 1) {
            DynamicError.throw_type_error();
        }
        AnyType at = arg.first();
        try {
            if (at instanceof XSDate) {
                XSDate val = (XSDate)NumericType.get_single_type(arg, XSDate.class);
                double res = this.value() - val.value();
                return ResultSequenceFactory.create_new(new XDTDayTimeDuration(res));
            }
            if (at instanceof XDTYearMonthDuration) {
                XDTYearMonthDuration val = (XDTYearMonthDuration)at;
                XSDate res = (XSDate)this.clone();
                res.calendar().add(2, val.value() * -1);
                return ResultSequenceFactory.create_new(res);
            }
            if (at instanceof XDTDayTimeDuration) {
                XDTDayTimeDuration val = (XDTDayTimeDuration)at;
                XSDate res = (XSDate)this.clone();
                res.calendar().add(14, (int)(val.value() * -1000.0));
                return ResultSequenceFactory.create_new(res);
            }
            DynamicError.throw_type_error();
            return null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            assert (false);
            return null;
        }
    }

    public ResultSequence plus(ResultSequence arg) throws DynamicError {
        if (arg.size() != 1) {
            DynamicError.throw_type_error();
        }
        AnyType at = arg.first();
        try {
            if (at instanceof XDTYearMonthDuration) {
                XDTYearMonthDuration val = (XDTYearMonthDuration)at;
                XSDate res = (XSDate)this.clone();
                res.calendar().add(2, val.value());
                return ResultSequenceFactory.create_new(res);
            }
            if (at instanceof XDTDayTimeDuration) {
                XDTDayTimeDuration val = (XDTDayTimeDuration)at;
                XSDate res = (XSDate)this.clone();
                res.calendar().add(14, (int)(val.value() * 1000.0));
                return ResultSequenceFactory.create_new(res);
            }
            DynamicError.throw_type_error();
            return null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            assert (false);
            return null;
        }
    }
}

