/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpGt;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpLt;
import org.eclipse.wst.xml.xpath2.processor.internal.function.MathMinus;
import org.eclipse.wst.xml.xpath2.processor.internal.function.MathPlus;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CalendarType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XDTDayTimeDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDateTime;

public class XSTime
extends CalendarType
implements CmpEq,
CmpLt,
CmpGt,
MathMinus,
MathPlus,
Cloneable {
    private Calendar _calendar;
    private boolean _timezoned;
    private XDTDayTimeDuration _tz;

    public XSTime(Calendar cal, XDTDayTimeDuration tz) {
        this._calendar = cal;
        this._tz = tz;
        this._timezoned = tz != null;
    }

    public XSTime() {
        this(new GregorianCalendar(), null);
    }

    public Object clone() throws CloneNotSupportedException {
        Calendar c = (Calendar)this.calendar().clone();
        XDTDayTimeDuration t = this.tz();
        if (t != null) {
            t = (XDTDayTimeDuration)t.clone();
        }
        return new XSTime(c, t);
    }

    public String type_name() {
        return "time";
    }

    public static XSTime parse_time(String str) {
        XSDateTime dt;
        String lame = "1983-11-29T";
        int index = str.indexOf(43, 1);
        if (index == -1) {
            index = str.indexOf(45, 1);
        }
        if (index == -1) {
            index = str.indexOf(90, 1);
        }
        if (index != -1) {
            // empty if block
        }
        if ((dt = XSDateTime.parseDateTime(String.valueOf(lame) + str)) == null) {
            return null;
        }
        return new XSTime(dt.calendar(), dt.tz());
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        XSTime t = XSTime.parse_time(aat.string_value());
        if (t == null) {
            throw DynamicError.cant_cast(null);
        }
        rs.add(t);
        return rs;
    }

    public int hour() {
        return this._calendar.get(11);
    }

    public int minute() {
        return this._calendar.get(12);
    }

    public double second() {
        double s = this._calendar.get(13);
        double ms = this._calendar.get(14);
        return s += (ms /= 1000.0);
    }

    public boolean timezoned() {
        return this._timezoned;
    }

    public String string_value() {
        String ret = "";
        ret = String.valueOf(ret) + XSDateTime.pad_int(this.hour(), 2);
        ret = String.valueOf(ret) + ":";
        ret = String.valueOf(ret) + XSDateTime.pad_int(this.minute(), 2);
        ret = String.valueOf(ret) + ":";
        int isecond = (int)this.second();
        double sec = this.second();
        ret = sec - (double)isecond == 0.0 ? String.valueOf(ret) + XSDateTime.pad_int(isecond, 2) : (sec < 10.0 ? String.valueOf(ret) + "0" + sec : String.valueOf(ret) + sec);
        if (this.timezoned()) {
            ret = String.valueOf(ret) + "Z";
        }
        return ret;
    }

    public String string_type() {
        return "xs:time";
    }

    public Calendar calendar() {
        return this._calendar;
    }

    public XDTDayTimeDuration tz() {
        return this._tz;
    }

    public double value() {
        return (double)this.calendar().getTimeInMillis() / 1000.0;
    }

    public boolean eq(AnyType arg) throws DynamicError {
        XSTime val = (XSTime)NumericType.get_single_type(arg, XSTime.class);
        return this.calendar().equals(val.calendar());
    }

    public boolean lt(AnyType arg) throws DynamicError {
        XSTime val = (XSTime)NumericType.get_single_type(arg, XSTime.class);
        return this.calendar().before(val.calendar());
    }

    public boolean gt(AnyType arg) throws DynamicError {
        XSTime val = (XSTime)NumericType.get_single_type(arg, XSTime.class);
        return this.calendar().after(val.calendar());
    }

    public ResultSequence minus(ResultSequence arg) throws DynamicError {
        AnyType at;
        if (arg.size() != 1) {
            DynamicError.throw_type_error();
        }
        if ((at = arg.first()) instanceof XSTime) {
            XSTime val = (XSTime)at;
            double res = this.value() - val.value();
            return ResultSequenceFactory.create_new(new XDTDayTimeDuration(res));
        }
        if (at instanceof XDTDayTimeDuration) {
            XDTDayTimeDuration val = (XDTDayTimeDuration)at;
            try {
                double ms = val.value() * -1000.0;
                XSTime res = (XSTime)this.clone();
                res.calendar().add(14, (int)ms);
                return ResultSequenceFactory.create_new(res);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                assert (false);
                return null;
            }
        }
        DynamicError.throw_type_error();
        return null;
    }

    public ResultSequence plus(ResultSequence arg) throws DynamicError {
        XDTDayTimeDuration val = (XDTDayTimeDuration)NumericType.get_single_type(arg, XDTDayTimeDuration.class);
        try {
            double ms = val.value() * 1000.0;
            XSTime res = (XSTime)this.clone();
            res.calendar().add(14, (int)ms);
            return ResultSequenceFactory.create_new(res);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            assert (false);
            return null;
        }
    }
}

