/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adapters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDAdapterFactory;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDParticleAdapter;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDVisitorForFields;
import org.eclipse.wst.xsd.ui.internal.adt.actions.SetInputToGraphView;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.IActionProvider;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.IGraphElement;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IADTObject;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IADTObjectListener;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IModel;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IStructure;
import org.eclipse.wst.xsd.ui.internal.adt.outline.ITreeElement;
import org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDElementAction;
import org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDModelGroupAction;
import org.eclipse.wst.xsd.ui.internal.common.actions.SetMultiplicityAction;
import org.eclipse.wst.xsd.ui.internal.common.commands.DeleteCommand;
import org.eclipse.wst.xsd.ui.internal.design.editparts.model.SpaceFiller;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;

public class XSDModelGroupDefinitionAdapter
extends XSDParticleAdapter
implements IStructure,
IActionProvider,
IGraphElement,
IADTObjectListener {
    public static final Image MODEL_GROUP_ICON = XSDEditorPlugin.getPlugin().getIcon("obj16/XSDGroup.gif");
    public static final Image MODEL_GROUP_DISABLED_ICON = XSDEditorPlugin.getPlugin().getIcon("obj16/XSDGroupdis.gif");
    public static final Image MODEL_GROUP_REF_ICON = XSDEditorPlugin.getPlugin().getIcon("obj16/XSDGroupRef.gif");
    public static final Image MODEL_GROUP_REF_DISABLED_ICON = XSDEditorPlugin.getPlugin().getIcon("obj16/XSDGroupRefdis.gif");
    protected List fields = null;
    protected List otherThingsToListenTo = null;

    public XSDModelGroupDefinition getXSDModelGroupDefinition() {
        return (XSDModelGroupDefinition)this.target;
    }

    public Image getImage() {
        XSDModelGroupDefinition xsdModelGroupDefinition = (XSDModelGroupDefinition)this.target;
        if (xsdModelGroupDefinition.isModelGroupDefinitionReference()) {
            if (this.isReadOnly()) {
                return MODEL_GROUP_REF_DISABLED_ICON;
            }
            return MODEL_GROUP_REF_ICON;
        }
        if (this.isReadOnly()) {
            return MODEL_GROUP_DISABLED_ICON;
        }
        return MODEL_GROUP_ICON;
    }

    public String getText() {
        XSDModelGroupDefinition xsdModelGroupDefinition = (XSDModelGroupDefinition)this.target;
        if (xsdModelGroupDefinition.getResolvedModelGroupDefinition().getContainer() == null) {
            return "";
        }
        String result = xsdModelGroupDefinition.isModelGroupDefinitionReference() ? xsdModelGroupDefinition.getQName() : xsdModelGroupDefinition.getName();
        return result == null ? Messages._UI_LABEL_ABSENT : result;
    }

    public ITreeElement[] getChildren() {
        XSDModelGroup xsdModelGroup;
        XSDModelGroupDefinition def = (XSDModelGroupDefinition)this.target;
        ArrayList<XSDModelGroup> list = new ArrayList<XSDModelGroup>();
        if (!def.isModelGroupDefinitionReference() && (xsdModelGroup = ((XSDModelGroupDefinition)this.target).getResolvedModelGroupDefinition().getModelGroup()) != null) {
            list.add(xsdModelGroup);
        }
        ArrayList adapterList = new ArrayList();
        this.populateAdapterList(list, adapterList);
        return adapterList.toArray(new ITreeElement[0]);
    }

    public String[] getActions(Object object) {
        ArrayList<String> list = new ArrayList<String>();
        XSDModelGroupDefinition modelGroupDefinition = this.getXSDModelGroupDefinition();
        boolean isModelGroupReference = modelGroupDefinition.isModelGroupDefinitionReference();
        if (!isModelGroupReference) {
            list.add(AddXSDElementAction.ID);
            list.add(AddXSDElementAction.REF_ID);
            list.add("org.eclipse.jface.action.Separator");
            list.add(AddXSDModelGroupAction.SEQUENCE_ID);
            list.add(AddXSDModelGroupAction.CHOICE_ID);
            list.add(AddXSDModelGroupAction.ALL_ID);
            list.add("org.eclipse.jface.action.Separator");
        }
        list.add("org.eclipse.wst.xsd.ui.internal.editor.DeleteAction");
        if (isModelGroupReference) {
            list.add("org.eclipse.jface.action.Separator");
            list.add("SUBMENU_START_ID: " + Messages._UI_ACTION_SET_MULTIPLICITY);
            list.add(SetMultiplicityAction.REQUIRED_ID);
            list.add(SetMultiplicityAction.ZERO_OR_ONE_ID);
            list.add(SetMultiplicityAction.ZERO_OR_MORE_ID);
            list.add(SetMultiplicityAction.ONE_OR_MORE_ID);
            list.add("SUBMENU_END_ID: ");
        }
        list.add("org.eclipse.jface.action.Separator");
        Object schema = this.getEditorSchema();
        if (modelGroupDefinition.getSchema() == schema) {
            XSDConcreteComponent container = modelGroupDefinition.getContainer();
            if (container == schema || container instanceof XSDRedefine) {
                list.add(SetInputToGraphView.ID);
            }
        } else {
            list.add("OpenInNewEditor");
        }
        list.add("org.eclipse.jface.action.Separator");
        list.add("org.eclipse.wst.xsd.ui.internal.adt.actions.ShowPropertiesViewAction");
        return list.toArray(new String[0]);
    }

    public Command getAddNewFieldCommand(String fieldKind) {
        return null;
    }

    public Command getDeleteCommand() {
        return new DeleteCommand((XSDConcreteComponent)this.getXSDModelGroupDefinition());
    }

    protected void clearFields() {
        if (this.otherThingsToListenTo != null) {
            Iterator i = this.otherThingsToListenTo.iterator();
            while (i.hasNext()) {
                Adapter adapter = (Adapter)i.next();
                if (!(adapter instanceof IADTObject)) continue;
                IADTObject adtObject = (IADTObject)adapter;
                adtObject.unregisterListener(this);
            }
        }
        this.fields = null;
        this.otherThingsToListenTo = null;
    }

    public List getFields() {
        ArrayList fields = new ArrayList();
        this.otherThingsToListenTo = new ArrayList();
        XSDVisitorForGroupFieldsWithSpaceFillers visitor = new XSDVisitorForGroupFieldsWithSpaceFillers();
        ((XSDVisitorForFields)visitor).visitModelGroupDefinition(this.getXSDModelGroupDefinition());
        this.populateAdapterList(visitor.concreteComponentList, fields);
        this.populateAdapterList(visitor.thingsWeNeedToListenTo, this.otherThingsToListenTo);
        Iterator i = this.otherThingsToListenTo.iterator();
        while (i.hasNext()) {
            Adapter adapter = (Adapter)i.next();
            if (!(adapter instanceof IADTObject)) continue;
            IADTObject adtObject = (IADTObject)adapter;
            adtObject.registerListener(this);
        }
        return fields;
    }

    public IModel getModel() {
        Adapter adapter = XSDAdapterFactory.getInstance().adapt((Notifier)this.getXSDModelGroupDefinition().getSchema());
        return (IModel)adapter;
    }

    public String getName() {
        return this.getText();
    }

    public boolean isFocusAllowed() {
        XSDModelGroupDefinition xsdModelGroupDefinition = (XSDModelGroupDefinition)this.target;
        return !xsdModelGroupDefinition.isModelGroupDefinitionReference();
    }

    public void propertyChanged(Object object, String property) {
        this.clearFields();
        this.notifyListeners(this, null);
    }

    public int getMaxOccurs() {
        return XSDModelGroupDefinitionAdapter.getMaxOccurs((XSDConcreteComponent)this.getXSDModelGroupDefinition());
    }

    public int getMinOccurs() {
        return XSDModelGroupDefinitionAdapter.getMinOccurs((XSDConcreteComponent)this.getXSDModelGroupDefinition());
    }

    public IADTObject getTopContainer() {
        XSDModelGroupDefinition group = this.getXSDModelGroupDefinition();
        XSDConcreteComponent container = group.getContainer();
        if (container instanceof XSDSchema || container instanceof XSDRedefine) {
            return this;
        }
        return this.getGlobalXSDContainer((XSDConcreteComponent)group);
    }

    protected class XSDVisitorForGroupFieldsWithSpaceFillers
    extends XSDVisitorForFields {
        public void visitModelGroup(XSDModelGroup modelGroup) {
            int numOfChildren = modelGroup.getContents().size();
            if (numOfChildren == 0) {
                this.concreteComponentList.add(new SpaceFiller("element"));
            }
            super.visitModelGroup(modelGroup);
        }

        public void visitModelGroupDefinition(XSDModelGroupDefinition modelGroupDef) {
            XSDModelGroupDefinition resolvedModelGroupDef = modelGroupDef.getResolvedModelGroupDefinition();
            if (this.visitedGroups.contains(resolvedModelGroupDef.getModelGroup())) {
                this.concreteComponentList.add(new SpaceFiller("element"));
            }
            super.visitModelGroupDefinition(modelGroupDef);
        }
    }
}

