/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.debug.debugger;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.wst.xsl.jaxp.debug.debugger.BreakPoint;
import org.eclipse.wst.xsl.jaxp.debug.debugger.IXSLDebugger;
import org.eclipse.wst.xsl.jaxp.debug.debugger.Variable;
import org.eclipse.wst.xsl.jaxp.debug.invoker.TransformationException;

public class DebugRunner {
    private static final Log log;
    private final BufferedReader requestIn;
    private final Writer requestOut;
    private final Writer eventOut;
    private final Writer generatedStream;
    private Socket eventSocket;
    private Socket requestSocket;
    private Socket generateSocket;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xsl.jaxp.debug.debugger.DebugRunner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public DebugRunner(BufferedReader requestIn, PrintWriter requestOut, PrintWriter eventOut, PrintWriter generatedStream) {
        this.requestOut = requestOut;
        this.requestIn = requestIn;
        this.eventOut = eventOut;
        this.generatedStream = generatedStream;
    }

    public DebugRunner(int requestPort, int eventPort, int generatePort) throws IOException {
        this.requestSocket = DebugRunner.getSocket(requestPort);
        this.eventSocket = DebugRunner.getSocket(eventPort);
        this.generateSocket = DebugRunner.getSocket(generatePort);
        this.requestIn = new BufferedReader(new InputStreamReader(this.requestSocket.getInputStream()));
        this.requestOut = new PrintWriter(this.requestSocket.getOutputStream(), true);
        this.eventOut = new PrintWriter(this.eventSocket.getOutputStream(), true);
        this.generatedStream = new BufferedWriter(new PrintWriter(this.generateSocket.getOutputStream(), true));
    }

    public void loop(IXSLDebugger debugger) throws TransformationException, IOException {
        debugger.setEventWriter(this.eventOut);
        debugger.setGeneratedWriter(this.generatedStream);
        this.eventOut.write("ready\n");
        this.eventOut.flush();
        log.debug((Object)"entering loop");
        try {
            String inputLine;
            while ((inputLine = this.requestIn.readLine()) != null) {
                BreakPoint breakpoint;
                String line;
                Variable var;
                String response = inputLine;
                log.debug((Object)("REQUEST:" + inputLine));
                Thread debuggerThread = null;
                if ("start".equals(inputLine)) {
                    debuggerThread = new Thread((Runnable)debugger, "debugger");
                    debuggerThread.start();
                } else if ("step into".equals(inputLine)) {
                    debugger.stepInto();
                } else if ("step over".equals(inputLine)) {
                    debugger.stepOver();
                } else if ("step return".equals(inputLine)) {
                    debugger.stepReturn();
                } else if ("suspend".equals(inputLine)) {
                    debugger.suspend();
                } else if ("resume".equals(inputLine)) {
                    debugger.resume();
                } else if ("stack".equals(inputLine)) {
                    response = debugger.stack();
                } else if (inputLine.startsWith("var")) {
                    String data = inputLine.substring("var".length() + 1);
                    int id = Integer.parseInt(data);
                    var = debugger.getVariable(id);
                    log.debug((Object)("var " + id + " = " + var));
                    response = String.valueOf(var.getScope()) + "&" + var.getName();
                } else if (inputLine.startsWith("value")) {
                    String data = inputLine.substring("value".length() + 1);
                    int id = Integer.parseInt(data);
                    var = debugger.getVariable(id);
                    response = String.valueOf(var.getType()) + "&" + var.getValueFirstLine();
                } else if (inputLine.startsWith("add")) {
                    int index = inputLine.lastIndexOf(32);
                    String file = inputLine.substring("add".length() + 1, index);
                    line = inputLine.substring(index + 1);
                    breakpoint = new BreakPoint(file, Integer.parseInt(line));
                    debugger.addBreakpoint(breakpoint);
                } else if (inputLine.startsWith("remove")) {
                    int index = inputLine.lastIndexOf(32);
                    String file = inputLine.substring("remove".length() + 1, index);
                    line = inputLine.substring(index + 1);
                    breakpoint = new BreakPoint(file, Integer.parseInt(line));
                    debugger.removeBreakpoint(breakpoint);
                } else {
                    response = "What?";
                }
                log.debug((Object)("RESPONSE:" + response));
                this.requestOut.write(String.valueOf(response) + "\n");
                this.requestOut.flush();
            }
        }
        catch (Exception e) {
            throw new TransformationException(e.getMessage(), e);
        }
        log.debug((Object)"exited loop");
        this.eventOut.write("terminated\n");
        this.eventOut.flush();
    }

    public void dispose() throws IOException {
        if (this.requestIn != null) {
            try {
                this.requestIn.close();
            }
            catch (IOException e) {
                log.error((Object)"Could not close request input stream", (Throwable)e);
            }
        }
        if (this.requestOut != null) {
            this.requestOut.close();
        }
        if (this.eventOut != null) {
            this.eventOut.close();
        }
        if (this.requestSocket != null) {
            try {
                this.requestSocket.close();
            }
            catch (IOException e) {
                log.error((Object)"Could not close request socket", (Throwable)e);
            }
        }
        if (this.eventSocket != null) {
            try {
                this.eventSocket.close();
            }
            catch (IOException e) {
                log.error((Object)"Could not close event socket", (Throwable)e);
            }
        }
    }

    private static Socket getSocket(int port) throws IOException {
        InetAddress localhost = InetAddress.getByName("localhost");
        ServerSocket serverSocket = new ServerSocket(port, 5, localhost);
        Socket clientSocket = serverSocket.accept();
        serverSocket.close();
        return clientSocket;
    }

    /*
     * Exception decompiling
     */
    public static void main(String[] args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 555->559)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static IXSLDebugger createDebugger(String classname) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = Class.forName(classname);
        return (IXSLDebugger)clazz.newInstance();
    }

    private static void handleFatalError(String msg, Throwable t) {
        log.fatal((Object)msg, t);
        System.exit(1);
    }
}

