/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.wtp.releng.tools.component.IClazz;
import org.eclipse.wtp.releng.tools.component.IClazzVisitor;
import org.eclipse.wtp.releng.tools.component.ILibrary;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.ILocationVisitor;
import org.eclipse.wtp.releng.tools.component.internal.Clazz;
import org.eclipse.wtp.releng.tools.component.internal.Location;

public class Library
implements ILibrary {
    private ILocation location;
    private Map typeNamesToTypes;

    public Library(ILocation location) {
        this.location = location;
        this.typeNamesToTypes = null;
    }

    private void init() {
        if (this.typeNamesToTypes == null) {
            this.typeNamesToTypes = new HashMap();
            this.location.accept(new ILocationVisitor(){

                public boolean accept(ILocation location) {
                    if (Location.getExtension(location.getName()).equals("class")) {
                        Clazz clazz = new Clazz(location);
                        Library.this.typeNamesToTypes.put(clazz.getName(), clazz);
                        clazz.resetClazz();
                    }
                    return true;
                }
            });
        }
    }

    public Map getTypes() {
        this.init();
        return this.typeNamesToTypes;
    }

    public void resetTypes() {
        this.typeNamesToTypes = null;
    }

    public void accept(IClazzVisitor visitor) {
        Iterator it = this.getTypes().values().iterator();
        while (it.hasNext()) {
            IClazz clazz = (IClazz)it.next();
            visitor.visit(clazz);
            clazz.resetClazz();
        }
    }
}

