/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.ui.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.wtp.releng.tools.component.IClazz;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.api.Source;
import org.eclipse.wtp.releng.tools.component.api.violation.ComponentViolationEmitter;
import org.eclipse.wtp.releng.tools.component.internal.Clazz;
import org.eclipse.wtp.releng.tools.component.internal.ComponentDepends;
import org.eclipse.wtp.releng.tools.component.internal.ComponentRef;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.ui.internal.WorkspaceFileLocation;
import org.eclipse.wtp.releng.tools.component.ui.internal.job.ScanComponent;

public class ScannableComponent
implements IResourceProxyVisitor {
    private ComponentXML compXML;
    private ComponentViolationEmitter emitter;
    private List projects;
    private long lastScan;
    private List newClasses;

    public ScannableComponent(ComponentXML compXML, ComponentViolationEmitter emitter, List projects) {
        this.compXML = compXML;
        this.emitter = emitter;
        this.projects = projects;
        this.lastScan = -1L;
        this.newClasses = new ArrayList();
    }

    public ComponentXML getCompXML() {
        return this.compXML;
    }

    public ComponentViolationEmitter getEmitter() {
        return this.emitter;
    }

    public List getProjects() {
        if (this.projects == null) {
            this.projects = new ArrayList(1);
        }
        return this.projects;
    }

    public void addProject(IProject project) {
        this.getProjects().add(project);
        new ScanComponent(this, true).schedule();
    }

    public IProject removeProject(String projectName) {
        if (this.projects != null) {
            int i = 0;
            while (i < this.projects.size()) {
                if (((IProject)this.projects.get(i)).getName().equals(projectName)) {
                    return (IProject)this.projects.remove(i);
                }
                ++i;
            }
        }
        return null;
    }

    public void addCompRef(ComponentXML compRef) {
        Map compRefs = this.emitter.getCompRefs();
        compRefs.put(compRef.getLocation().getAbsolutePath(), compRef);
        this.emitter.setCompRefs(compRefs);
        if (this.isDependsOn(compRef.getName())) {
            new ScanComponent(this, true).schedule();
        }
    }

    public void removeCompRef(ILocation location) {
        String key;
        Map compRefs = this.emitter.getCompRefs();
        if (compRefs.containsKey(key = location.getAbsolutePath())) {
            ComponentXML compRef = (ComponentXML)compRefs.remove(key);
            this.emitter.setCompRefs(compRefs);
            if (this.isDependsOn(compRef.getName())) {
                new ScanComponent(this, true).schedule();
            }
        }
    }

    private boolean isDependsOn(String compRefName) {
        if (!compRefName.equals(this.compXML.getName())) {
            ComponentDepends depends = this.compXML.getComponentDepends();
            if (depends.isUnrestricted()) {
                return true;
            }
            Collection compRefs = depends.getComponentRefs();
            Iterator it = compRefs.iterator();
            while (it.hasNext()) {
                if (!((ComponentRef)it.next()).getName().equals(compRefName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isScanningProject(IProject project) {
        if (this.projects != null && project != null) {
            Iterator it = this.projects.iterator();
            while (it.hasNext()) {
                if (!project.getName().equals(((IProject)it.next()).getName())) continue;
                return true;
            }
        }
        return false;
    }

    public List scan() throws IOException {
        return this.scan(false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized List scan(boolean force) throws IOException {
        if (force) {
            this.lastScan = -1L;
        }
        this.newClasses.clear();
        ArrayList<Source> sources = new ArrayList<Source>();
        IJobManager jobManager = Platform.getJobManager();
        int i = 0;
        while (true) {
            Object var6_7;
            if (i >= this.projects.size()) break;
            IProject project = (IProject)this.projects.get(i);
            try {
                jobManager.beginRule((ISchedulingRule)project, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Throwable throwable) {
                var6_7 = null;
                jobManager.endRule((ISchedulingRule)project);
                throw throwable;
            }
            {
                var6_7 = null;
            }
            jobManager.endRule((ISchedulingRule)project);
            {
                project.accept((IResourceProxyVisitor)this, 2);
            }
            ++i;
        }
        this.lastScan = Calendar.getInstance().getTimeInMillis();
        String compLoc = this.compXML.getLocation().getAbsolutePath();
        Iterator it = this.newClasses.iterator();
        while (true) {
            if (!it.hasNext()) {
                this.newClasses.clear();
                return sources;
            }
            Source source = this.emitter.genViolation(compLoc, (IClazz)it.next());
            if (source == null) continue;
            sources.add(source);
        }
    }

    public boolean visit(IResourceProxy resProxy) {
        if (resProxy.getType() == 1 && resProxy.getName().endsWith(".class") && resProxy.getModificationStamp() > this.lastScan) {
            this.newClasses.add(new Clazz((ILocation)new WorkspaceFileLocation((IFile)resProxy.requestResource())));
        }
        return true;
    }
}

