/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.results;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.test.internal.performance.InternalDimensions;
import org.eclipse.test.internal.performance.PerformanceTestPlugin;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.results.PerformanceResults;

public abstract class AbstractResults
implements Comparable {
    public static final Dim[] SUPPORTED_DIMS;
    public static final String[] CONFIGS;
    public static final String[] BOXES;
    protected static final SimpleDateFormat DATE_FORMAT;
    public static final String VERSION_REF;
    public static final String VERSION;
    AbstractResults parent;
    int id = -1;
    String name;
    List children;
    private boolean newLine = true;
    boolean print = false;

    static {
        String version;
        SUPPORTED_DIMS = new Dim[]{InternalDimensions.ELAPSED_PROCESS, InternalDimensions.CPU_TIME};
        BOXES = new String[]{"RHEL 4.0 Sun 1.4.2_10 (3 GHz 2.5 GB)", "Win XP Sun 1.4.2_10 (3 GHz 2 GB)", "RHEL 3.0 Sun 1.4.2_10 (3 GHz 2 GB)", "Win XP Sun 1.4.2_10 (2 GHz 512 MB)", "RHEL 3.0 Sun 1.4.2_10 (2 GHz 512 MB)"};
        DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmm");
        String dbName = PerformanceTestPlugin.getDBName();
        if (dbName.equals("perfDB")) {
            version = "_R3.3";
            VERSION_REF = "3.2";
            int mainVersion = 51;
            int minorVersion = 51;
            VERSION = "3.3";
        } else {
            char mainVersion = dbName.charAt(dbName.length() - 2);
            char minorVersion = dbName.charAt(dbName.length() - 1);
            version = "";
            VERSION_REF = String.valueOf(mainVersion) + "." + (char)(minorVersion - '\u0001');
            VERSION = String.valueOf(mainVersion) + "." + minorVersion;
        }
        CONFIGS = new String[]{"eclipseperflnx3" + version, "eclipseperfwin2" + version, "eclipseperflnx2" + version, "eclipseperfwin1" + version, "eclipseperflnx1" + version};
    }

    static String getBuildDate(String buildName, String baselinePrefix) {
        if (buildName.startsWith(baselinePrefix)) {
            int length = buildName.length();
            return buildName.substring(length - 12, length);
        }
        char first = buildName.charAt(0);
        if (first == 'N' || first == 'I' || first == 'M') {
            return String.valueOf(buildName.substring(1, 9)) + buildName.substring(10, 14);
        }
        int length = buildName.length() - 12;
        int i = 0;
        while (i <= length) {
            try {
                String substring = i == 0 ? buildName : buildName.substring(i);
                DATE_FORMAT.parse(substring);
                return substring;
            }
            catch (ParseException parseException) {
                ++i;
            }
        }
        return null;
    }

    static Dim getDimension(int id) {
        int length = SUPPORTED_DIMS.length;
        int i = 0;
        while (i < length) {
            if (SUPPORTED_DIMS[i].getId() == id) {
                return SUPPORTED_DIMS[i];
            }
            ++i;
        }
        return null;
    }

    AbstractResults(AbstractResults parent, String name) {
        this.parent = parent;
        this.children = new ArrayList();
        this.name = name;
    }

    AbstractResults(AbstractResults parent, int id) {
        this.parent = parent;
        this.children = new ArrayList();
        this.id = id;
    }

    void addChild(Comparable child, boolean sort) {
        if (sort) {
            int size = this.children.size();
            int i = 0;
            while (i < size) {
                Object results = this.children.get(i);
                if (child.compareTo(results) < 0) {
                    this.children.add(i, child);
                    return;
                }
                ++i;
            }
        }
        this.children.add(child);
    }

    public int compareTo(Object obj) {
        if (obj instanceof AbstractResults) {
            AbstractResults res = (AbstractResults)obj;
            return this.getName().compareTo(res.getName());
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractResults) {
            return this.name.equals(((AbstractResults)obj).getName());
        }
        return super.equals(obj);
    }

    int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    PerformanceResults getPerformance() {
        if (this.parent != null) {
            return this.parent.getPerformance();
        }
        return null;
    }

    String getPath() {
        String path = this.parent == null || this.parent.parent == null ? "" : String.valueOf(this.parent.getPath()) + ">";
        return String.valueOf(path) + this.name;
    }

    public Iterator getResults() {
        return this.children.iterator();
    }

    AbstractResults getResults(String resultName) {
        int size = this.children.size();
        int i = 0;
        while (i < size) {
            AbstractResults searchedResults = (AbstractResults)this.children.get(i);
            if (searchedResults.getName().equals(resultName)) {
                return searchedResults;
            }
            ++i;
        }
        return null;
    }

    AbstractResults getResults(int searchedId) {
        int size = this.children.size();
        int i = 0;
        while (i < size) {
            AbstractResults searchedResults = (AbstractResults)this.children.get(i);
            if (searchedResults.id == searchedId) {
                return searchedResults;
            }
            ++i;
        }
        return null;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    void printTab() {
        if (this.parent != null) {
            if (this.print) {
                System.out.print("\t");
            }
            this.parent.printTab();
        }
    }

    void print(String text) {
        if (this.print) {
            if (this.newLine) {
                this.printTab();
            }
            System.out.print(text);
            this.newLine = false;
        }
    }

    void printGlobalTime(long start) {
        this.printGlobalTime(start, null);
    }

    void printGlobalTime(long start, String end) {
        StringBuffer buffer = new StringBuffer("=> time spent in '");
        buffer.append(this.name);
        buffer.append("' was ");
        buffer.append((double)(System.currentTimeMillis() - start) / 1000.0);
        if (end == null) {
            buffer.append('s');
        } else {
            buffer.append("s. ");
            buffer.append(end.trim());
        }
        this.println(buffer);
    }

    void println(String text) {
        if (this.print) {
            if (this.newLine) {
                this.printTab();
            }
            System.out.println(text);
            this.newLine = true;
        }
    }

    void println(StringBuffer buffer) {
        this.println(buffer.toString());
    }

    public int size() {
        return this.children == null ? 0 : this.children.size();
    }

    public String toString() {
        return this.getPath();
    }
}

