/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import org.eclipse.core.runtime.Assert;
import org.eclipse.egit.ui.internal.commit.ILogicalLineNumberProvider;
import org.eclipse.egit.ui.internal.commit.LogicalLineNumberProvider;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.diff.DiffEntry;

public class LogicalLineNumberRulerColumn
extends LineNumberRulerColumn {
    private ILogicalLineNumberProvider logicalLineNumberProvider;
    @NonNull
    private final DiffEntry.Side side;
    int zoom = 100;

    public LogicalLineNumberRulerColumn(@NonNull DiffEntry.Side side) {
        this.side = side;
    }

    @NonNull
    protected DiffEntry.Side getSide() {
        return this.side;
    }

    protected ILogicalLineNumberProvider getLogicalLineNumberProvider() {
        if (this.logicalLineNumberProvider == null) {
            ITextViewer viewer = this.getParentRuler().getTextViewer();
            Assert.isNotNull((Object)viewer);
            this.logicalLineNumberProvider = new LogicalLineNumberProvider(this.getSide(), viewer);
        }
        return this.logicalLineNumberProvider;
    }

    protected String createDisplayString(int line) {
        int logicalLine = this.getLogicalLineNumberProvider().getLogicalLine(line);
        return logicalLine < 0 ? "" : Integer.toString(logicalLine + 1);
    }

    protected int computeNumberOfDigits() {
        int max = this.getLogicalLineNumberProvider().getMaximum();
        int digits = 2;
        while ((double)max > Math.pow(10.0, digits) - 1.0) {
            ++digits;
        }
        return digits;
    }

    protected boolean internalSupportsZoomedPaint() {
        return true;
    }

    protected void internalSetZoom(int zoomLevel) {
        this.zoom = zoomLevel;
    }
}

