/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.payloads;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.BytesRef;

public class TypeAsPayloadTokenFilter
extends TokenFilter {
    private final PayloadAttribute payloadAtt = (PayloadAttribute)this.addAttribute(PayloadAttribute.class);
    private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);

    public TypeAsPayloadTokenFilter(TokenStream input) {
        super(input);
    }

    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            String type = this.typeAtt.type();
            if (type != null && !type.isEmpty()) {
                this.payloadAtt.setPayload(new BytesRef((CharSequence)type));
            }
            return true;
        }
        return false;
    }
}

