/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.LaunchConfigurationAction;
import org.eclipse.debug.internal.ui.actions.LaunchShortcutAction;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.debug.internal.ui.stringsubstitution.SelectedResourceManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class LaunchShortcutsAction
extends Action
implements IMenuCreator,
IWorkbenchWindowPulldownDelegate2 {
    private Menu fCreatedMenu;
    private ILaunchGroup fGroup;
    private boolean fInitialized = false;

    public LaunchShortcutsAction(String launchGroupIdentifier) {
        this.fGroup = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(launchGroupIdentifier);
        ILaunchMode mode = DebugPlugin.getDefault().getLaunchManager().getLaunchMode(this.fGroup.getMode());
        this.setText(mode.getLaunchAsLabel());
        this.setMenuCreator(this);
        this.setEnabled(this.existsConfigTypesForMode());
    }

    public void run() {
    }

    public void dispose() {
        if (this.fCreatedMenu != null) {
            this.fCreatedMenu.dispose();
        }
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public Menu getMenu(Menu parent) {
        if (this.fCreatedMenu != null) {
            this.fCreatedMenu.dispose();
        }
        this.fCreatedMenu = new Menu(parent);
        this.initMenu();
        return this.fCreatedMenu;
    }

    private IEvaluationContext createContext() {
        IStructuredSelection ss = SelectedResourceManager.getDefault().getCurrentSelection();
        Object o = ss.getFirstElement();
        ArrayList<IEditorInput> list = new ArrayList<IEditorInput>(0);
        if (o instanceof IEditorPart) {
            list.add(((IEditorPart)o).getEditorInput());
        } else {
            list.addAll(ss.toList());
        }
        IEvaluationContext context = DebugUIPlugin.createEvaluationContext(list);
        context.setAllowPluginActivation(true);
        context.addVariable("selection", list);
        return context;
    }

    private void fillMenu() {
        IEvaluationContext context = this.createContext();
        int accelerator = 1;
        List<LaunchShortcutExtension> allShortCuts = this.getLaunchConfigurationManager().getLaunchShortcuts(this.fGroup.getCategory());
        Iterator<LaunchShortcutExtension> iter = allShortCuts.iterator();
        ArrayList<LaunchShortcutExtension> filteredShortCuts = new ArrayList<LaunchShortcutExtension>(10);
        while (iter.hasNext()) {
            LaunchShortcutExtension ext = iter.next();
            try {
                if (WorkbenchActivityHelper.filterItem((Object)ext) || !this.isApplicable(ext, context)) continue;
                filteredShortCuts.add(ext);
            }
            catch (CoreException e) {
                Status status = new Status(4, DebugUIPlugin.getUniqueIdentifier(), "Launch shortcut '" + ext.getId() + "' enablement expression caused exception. Shortcut was removed.", (Throwable)e);
                DebugUIPlugin.log((IStatus)status);
                iter.remove();
            }
        }
        String mode = this.getMode();
        try {
            ILaunchConfiguration config = this.getLaunchConfigurationManager().isSharedConfig(this.getSelection(context));
            if (config != null && config.exists() && config.supportsMode(mode)) {
                Object action = new LaunchConfigurationAction(config, mode, config.getName(), DebugUITools.getDefaultImageDescriptor(config), accelerator++);
                ActionContributionItem item = new ActionContributionItem(action);
                item.fill(this.fCreatedMenu, -1);
                if (!filteredShortCuts.isEmpty()) {
                    new MenuItem(this.fCreatedMenu, 2);
                }
            }
        }
        catch (CoreException ce) {
            DebugUIPlugin.log(ce);
        }
        for (LaunchShortcutExtension ext : filteredShortCuts) {
            for (String modee : ext.getModes()) {
                if (!modee.equals(mode)) continue;
                this.populateMenuItem(modee, ext, this.fCreatedMenu, accelerator++);
            }
        }
        if (accelerator == 1) {
            Action action = new Action(ActionMessages.LaunchShortcutsAction_1){};
            action.setEnabled(false);
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(this.fCreatedMenu, -1);
        }
    }

    private Object getSelection(IEvaluationContext context) {
        List list = (List)context.getVariable("selection");
        return list.isEmpty() ? null : list.get(0);
    }

    private void populateMenuItem(String mode, LaunchShortcutExtension ext, Menu menu, int accelerator) {
        String contextLabel;
        LaunchShortcutAction action = new LaunchShortcutAction(mode, ext);
        action.setActionDefinitionId(String.valueOf(ext.getId()) + "." + mode);
        String helpContextId = ext.getHelpContextId();
        if (helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, helpContextId);
        }
        StringBuilder label = new StringBuilder();
        if (accelerator >= 0 && accelerator < 10) {
            label.append('&');
            label.append(accelerator);
            label.append(' ');
        }
        label.append((contextLabel = ext.getContextLabel(mode)) != null ? contextLabel : action.getText());
        action.setText(label.toString());
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(menu, -1);
    }

    private boolean isApplicable(LaunchShortcutExtension ext, IEvaluationContext context) throws CoreException {
        Expression expr = ext.getContextualLaunchEnablementExpression();
        return ext.evalEnablementExpression(context, expr);
    }

    private void initMenu() {
        this.fCreatedMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                MenuItem[] items;
                Menu m = (Menu)e.widget;
                MenuItem[] menuItemArray = items = m.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    item.dispose();
                    ++n2;
                }
                LaunchShortcutsAction.this.fillMenu();
            }
        });
    }

    protected String getMode() {
        return this.fGroup.getMode();
    }

    private LaunchConfigurationManager getLaunchConfigurationManager() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager();
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!this.fInitialized) {
            action.setEnabled(this.existsConfigTypesForMode());
            this.fInitialized = true;
        }
    }

    private boolean existsConfigTypesForMode() {
        ILaunchConfigurationType[] configTypes;
        ILaunchConfigurationType[] iLaunchConfigurationTypeArray = configTypes = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes();
        int n = configTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationType configType = iLaunchConfigurationTypeArray[n2];
            if (configType.supportsMode(this.getMode())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

