/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.confluence.internal.phrase;

import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.confluence.internal.ConfluenceContentState;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElementProcessor;

public class HyperlinkPhraseModifier
extends PatternBasedElement {
    private static final Pattern QUALIFIED_HREF_PATTERN = Pattern.compile("(#|([a-z]{2,6}:)).*", 2);
    private final boolean parseRelativeLinks;

    public HyperlinkPhraseModifier(boolean parseRelativeLinks) {
        this.parseRelativeLinks = parseRelativeLinks;
    }

    protected String getPattern(int groupOffset) {
        return "\\[(?:\\s*([^\\[\\]\\|]+)\\|)?([^\\[\\]]+)\\]";
    }

    protected int getPatternGroupCount() {
        return 2;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new HyperlinkPhraseModifierProcessor(this.parseRelativeLinks);
    }

    private static class HyperlinkPhraseModifierProcessor
    extends PatternBasedElementProcessor {
        private final boolean parseRelativeLinks;

        public HyperlinkPhraseModifierProcessor(boolean parseRelativeLinks) {
            this.parseRelativeLinks = parseRelativeLinks;
        }

        public void emit() {
            String text = this.group(1);
            String linkComposite = this.group(2);
            String[] parts = linkComposite.split("\\s*\\|\\s*");
            if (parts.length != 0) {
                String tip;
                String href;
                if (text != null) {
                    text = text.trim();
                }
                if ((href = parts[0]) != null) {
                    href = href.trim();
                }
                String string = tip = parts.length > 1 ? parts[1] : null;
                if (tip != null) {
                    tip = tip.trim();
                }
                if (!this.shouldEmitAsLink(text, href)) {
                    this.getBuilder().characters(this.group(0));
                    return;
                }
                if (text == null || text.length() == 0) {
                    text = href;
                    if (text != null && text.length() > 0 && text.charAt(0) == '#') {
                        text = text.substring(1);
                    }
                    LinkAttributes attributes = new LinkAttributes();
                    attributes.setTitle(tip);
                    this.getBuilder().link((Attributes)attributes, this.toInternalHref(href), text);
                } else {
                    LinkAttributes attributes = new LinkAttributes();
                    attributes.setTitle(tip);
                    attributes.setHref(this.toInternalHref(href));
                    this.getBuilder().beginSpan(DocumentBuilder.SpanType.LINK, (Attributes)attributes);
                    this.emitLinkText(text);
                    this.getBuilder().endSpan();
                }
            }
        }

        private void emitLinkText(String text) {
            this.getState().setWithinLink(true);
            this.getMarkupLanguage().emitMarkupLine(this.parser, this.state, this.start(1), text, 0);
            this.getState().setWithinLink(false);
        }

        public ConfluenceContentState getState() {
            return (ConfluenceContentState)super.getState();
        }

        private boolean shouldEmitAsLink(String text, String href) {
            return this.parseRelativeLinks || this.isQualifiedLink(href);
        }

        private String toInternalHref(String href) {
            if (this.isQualifiedLink(href)) {
                return href;
            }
            String internalLinkPattern = this.getMarkupLanguage().getInternalLinkPattern();
            if (internalLinkPattern != null) {
                return MessageFormat.format(internalLinkPattern, href);
            }
            return href;
        }

        private boolean isQualifiedLink(String href) {
            return QUALIFIED_HREF_PATTERN.matcher(href).matches();
        }
    }
}

