/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.codeactions;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.command.CommandExecutor;
import org.eclipse.lsp4e.operations.codeactions.CodeActionCompletionProposal;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class CodeActionMarkerResolution
extends WorkbenchMarkerResolution
implements IMarkerResolution {
    private CodeAction codeAction;

    public CodeActionMarkerResolution(CodeAction codeAction) {
        this.codeAction = codeAction;
    }

    public String getDescription() {
        return this.codeAction.getTitle();
    }

    public Image getImage() {
        return null;
    }

    public String getLabel() {
        return this.codeAction.getTitle();
    }

    public void run(IMarker marker) {
        if (this.codeAction.getEdit() != null) {
            LSPEclipseUtils.applyWorkspaceEdit(this.codeAction.getEdit(), this.codeAction.getTitle());
            return;
        }
        String languageServerId = marker.getAttribute("languageServerId", null);
        LanguageServersRegistry.LanguageServerDefinition definition = languageServerId != null ? LanguageServersRegistry.getInstance().getDefinition(languageServerId) : null;
        try {
            IResource resource;
            LanguageServerWrapper wrapper = null;
            if (definition != null && (resource = marker.getResource()) != null) {
                wrapper = LanguageServiceAccessor.getLSWrapper(resource.getProject(), definition);
            }
            if (wrapper != null) {
                CodeAction resolvedCodeAction;
                if (this.codeAction.getEdit() == null && CodeActionCompletionProposal.isCodeActionResolveSupported(wrapper.getServerCapabilities()) && (resolvedCodeAction = (CodeAction)wrapper.execute(ls -> ls.getTextDocumentService().resolveCodeAction(this.codeAction)).get(2L, TimeUnit.SECONDS)) != null) {
                    this.codeAction = resolvedCodeAction;
                }
                if (this.codeAction.getEdit() != null) {
                    LSPEclipseUtils.applyWorkspaceEdit(this.codeAction.getEdit(), this.codeAction.getTitle());
                }
                if (this.codeAction.getCommand() != null) {
                    Command command = this.codeAction.getCommand();
                    ExecuteCommandOptions provider = wrapper.getServerCapabilities().getExecuteCommandProvider();
                    if (provider != null && provider.getCommands().contains(command.getCommand())) {
                        wrapper.execute(ls -> ls.getWorkspaceService().executeCommand(new ExecuteCommandParams(command.getCommand(), command.getArguments())));
                    } else {
                        IResource resource2 = marker.getResource();
                        if (resource2 != null) {
                            CommandExecutor.executeCommandClientSide(command, resource2);
                        }
                    }
                }
            }
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException ex) {
            LanguageServerPlugin.logError(ex);
        }
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        if (markers == null) {
            return new IMarker[0];
        }
        return (IMarker[])Arrays.stream(markers).filter(marker -> {
            try {
                return this.codeAction.getDiagnostics().contains(marker.getAttribute("lspDiagnostic"));
            }
            catch (CoreException e) {
                LanguageServerPlugin.logError(e);
                return false;
            }
        }).toArray(IMarker[]::new);
    }
}

