/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.declaration;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.ui.intro.config.IIntroURL;
import org.eclipse.ui.intro.config.IntroURLFactory;

public class LSBasedHyperlink
implements IHyperlink {
    private final Either<Location, LocationLink> location;
    private final IRegion highlightRegion;
    private final String locationType;

    public LSBasedHyperlink(Either<Location, LocationLink> location, IRegion highlightRegion, String locationType) {
        this.location = location;
        this.highlightRegion = highlightRegion;
        this.locationType = locationType;
    }

    public LSBasedHyperlink(@NonNull Location location, IRegion linkRegion, String locationType) {
        this((Either<Location, LocationLink>)Either.forLeft((Object)location), linkRegion, locationType);
    }

    public LSBasedHyperlink(@NonNull LocationLink locationLink, IRegion linkRegion, String locationType) {
        this((Either<Location, LocationLink>)Either.forRight((Object)locationLink), linkRegion, locationType);
    }

    public IRegion getHyperlinkRegion() {
        return this.highlightRegion;
    }

    public String getTypeLabel() {
        return this.getLabel();
    }

    public String getHyperlinkText() {
        return this.getLabel();
    }

    public Either<Location, LocationLink> getLocation() {
        return this.location;
    }

    public void open() {
        if (this.location.isLeft()) {
            LSPEclipseUtils.openInEditor((Location)this.location.getLeft());
        } else {
            LSPEclipseUtils.openInEditor((LocationLink)this.location.getRight());
        }
    }

    private String getLabel() {
        if (this.location != null) {
            String uri;
            String string = uri = this.location.isLeft() ? ((Location)this.location.getLeft()).getUri() : ((LocationLink)this.location.getRight()).getTargetUri();
            if (uri != null) {
                if (uri.startsWith("file://") && uri.length() > "file://".length()) {
                    return this.getFileBasedLabel(uri);
                }
                if (uri.startsWith("http://org.eclipse.ui.intro")) {
                    return this.getIntroUrlBasedLabel(uri);
                }
                return this.getGenericUriBasedLabel(uri);
            }
        }
        return this.locationType;
    }

    private String getIntroUrlBasedLabel(String uri) {
        try {
            String label;
            IIntroURL introUrl = IntroURLFactory.createIntroURL((String)uri);
            if (introUrl != null && (label = introUrl.getParameter("label")) != null) {
                return String.valueOf(this.locationType) + " - " + label;
            }
        }
        catch (Exception e) {
            LanguageServerPlugin.logError(e.getMessage(), e);
        }
        return this.locationType;
    }

    private String getGenericUriBasedLabel(String uri) {
        return String.valueOf(this.locationType) + " - " + uri;
    }

    private String getFileBasedLabel(String uri) {
        return String.valueOf(this.locationType) + " - " + uri.substring("file://".length());
    }
}

