/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.ui.refactoring.model;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringDescriptorProxyAdapter;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryImplementation;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.model.RefactoringDescriptorSynchronizationProxy;
import org.eclipse.ltk.ui.refactoring.model.AbstractResourceMappingMerger;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.diff.ITwoWayDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.IResourceDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.ui.mapping.SynchronizationContentProvider;

public abstract class AbstractSynchronizationContentProvider
extends SynchronizationContentProvider {
    protected RefactoringHistory getRefactorings(ISynchronizationContext context, IProject project, IProgressMonitor monitor) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)project);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(RefactoringUIMessages.RefactoringModelMerger_retrieving_refactorings, -1);
            IProgressMonitor finalMonitor = monitor;
            HashSet result = new HashSet();
            IResourceDiffTree tree = context.getDiffTree();
            tree.accept(project.getFolder(".refactorings").getFullPath(), diff -> {
                if (diff instanceof IThreeWayDiff) {
                    Object name2;
                    IResourceDiff resourceDiff2;
                    IFileRevision revision2;
                    ITwoWayDiff remoteDiff;
                    String name1;
                    IResourceDiff resourceDiff1;
                    IFileRevision revision1;
                    IThreeWayDiff threeWay = (IThreeWayDiff)diff;
                    HashSet<RefactoringDescriptor> localDescriptors = new HashSet<RefactoringDescriptor>();
                    HashSet<RefactoringDescriptor> remoteDescriptors = new HashSet<RefactoringDescriptor>();
                    ITwoWayDiff localDiff = threeWay.getLocalChange();
                    if (localDiff instanceof IResourceDiff && localDiff.getKind() != 0 && (revision1 = (resourceDiff1 = (IResourceDiff)localDiff).getAfterState()) != null && "refactorings.history".equalsIgnoreCase(name1 = revision1.getName())) {
                        AbstractResourceMappingMerger.getRefactoringDescriptors(revision1, localDescriptors, (IProgressMonitor)new SubProgressMonitor(finalMonitor, 1, 2));
                    }
                    if ((remoteDiff = threeWay.getLocalChange()) instanceof IResourceDiff && remoteDiff.getKind() != 0 && (revision2 = (resourceDiff2 = (IResourceDiff)remoteDiff).getAfterState()) != null && "refactorings.history".equalsIgnoreCase((String)(name2 = revision2.getName()))) {
                        AbstractResourceMappingMerger.getRefactoringDescriptors(revision2, remoteDescriptors, (IProgressMonitor)new SubProgressMonitor(finalMonitor, 1, 2));
                    }
                    HashSet local = new HashSet(localDescriptors);
                    local.removeAll(remoteDescriptors);
                    for (RefactoringDescriptor descriptor : local) {
                        result.add(new RefactoringDescriptorSynchronizationProxy((RefactoringDescriptorProxy)new RefactoringDescriptorProxyAdapter(descriptor), project.getName(), 256));
                    }
                    HashSet remote = new HashSet(remoteDescriptors);
                    remote.removeAll(localDescriptors);
                    for (RefactoringDescriptor descriptor : remote) {
                        result.add(new RefactoringDescriptorSynchronizationProxy((RefactoringDescriptorProxy)new RefactoringDescriptorProxyAdapter(descriptor), project.getName(), 512));
                    }
                }
                return true;
            }, 2);
            for (RefactoringDescriptorSynchronizationProxy proxy : result) {
                if (this.includeDirection(proxy.getDirection())) continue;
                result.remove((Object)proxy);
            }
            RefactoringHistoryImplementation refactoringHistoryImplementation = new RefactoringHistoryImplementation(result.toArray(new RefactoringDescriptorProxy[result.size()]));
            return refactoringHistoryImplementation;
        }
        finally {
            monitor.done();
        }
    }
}

