/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.ant;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.mylyn.wikitext.ant.internal.Messages;
import org.eclipse.mylyn.wikitext.parser.markup.AbstractMarkupLanguage;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguageConfiguration;
import org.eclipse.mylyn.wikitext.util.ServiceLocator;
import org.eclipse.mylyn.wikitext.validation.StandaloneMarkupValidator;
import org.eclipse.mylyn.wikitext.validation.ValidationProblem;

public abstract class MarkupTask
extends Task {
    private String markupLanguage;
    private String internalLinkPattern;
    private boolean validate = true;
    private boolean failOnValidationError = true;
    private boolean failOnValidationWarning = false;
    private MarkupLanguageConfiguration markupLanguageConfiguration;
    private String sourceEncoding;

    public String getMarkupLanguage() {
        return this.markupLanguage;
    }

    public void setMarkupLanguage(String markupLanguage) {
        this.markupLanguage = markupLanguage;
    }

    public MarkupLanguageConfiguration getMarkupLanguageConfiguration() {
        return this.markupLanguageConfiguration;
    }

    public void setMarkupLanguageConfiguration(MarkupLanguageConfiguration markupLanguageConfiguration) {
        this.markupLanguageConfiguration = markupLanguageConfiguration;
    }

    protected MarkupLanguage createMarkupLanguage() throws BuildException {
        if (this.markupLanguage == null) {
            throw new BuildException(Messages.getString("MarkupTask.0"));
        }
        try {
            MarkupLanguage language = ServiceLocator.getInstance((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getMarkupLanguage(this.markupLanguage);
            if (this.internalLinkPattern != null) {
                this.checkAbstractMarkupLanguage(language, "internalLinkPattern");
                ((AbstractMarkupLanguage)language).setInternalLinkPattern(this.internalLinkPattern);
            }
            if (this.markupLanguageConfiguration != null) {
                language.configure(this.markupLanguageConfiguration);
            }
            return language;
        }
        catch (IllegalArgumentException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    private void checkAbstractMarkupLanguage(MarkupLanguage language, String field) {
        if (!(language instanceof AbstractMarkupLanguage)) {
            throw new BuildException(MessageFormat.format(Messages.getString("MarkupTask.2"), field, language.getName()));
        }
    }

    public void setInternalLinkPattern(String internalLinkPattern) {
        this.internalLinkPattern = internalLinkPattern;
    }

    public String getInternalLinkPattern() {
        return this.internalLinkPattern;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public boolean isFailOnValidationError() {
        return this.failOnValidationError;
    }

    public void setFailOnValidationError(boolean failOnValidationError) {
        this.failOnValidationError = failOnValidationError;
    }

    public boolean isFailOnValidationWarning() {
        return this.failOnValidationWarning;
    }

    public void setFailOnValidationWarning(boolean failOnValidationWarning) {
        this.failOnValidationWarning = failOnValidationWarning;
    }

    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    protected void performValidation(File source, String markupContent) {
        if (!this.validate) {
            return;
        }
        if (this.markupLanguage == null) {
            throw new IllegalStateException();
        }
        this.log(MessageFormat.format(Messages.getString("MarkupTask.1"), source), 3);
        StandaloneMarkupValidator markupValidator = StandaloneMarkupValidator.getValidator((String)this.markupLanguage);
        List problems = markupValidator.validate(markupContent);
        int errorCount = 0;
        int warningCount = 0;
        for (ValidationProblem problem : problems) {
            int messageLevel = 0;
            if (problem.getSeverity() == ValidationProblem.Severity.ERROR) {
                ++errorCount;
            } else if (problem.getSeverity() == ValidationProblem.Severity.WARNING) {
                ++warningCount;
                messageLevel = 1;
            }
            this.log(String.format("%s:%s %s", source.getName(), problem.getOffset(), problem.getMessage()), messageLevel);
        }
        if (errorCount > 0 && this.failOnValidationError || warningCount > 0 && this.failOnValidationWarning) {
            throw new BuildException(MessageFormat.format(Messages.getString("MarkupTask.3"), errorCount, warningCount, source));
        }
    }

    public void addConfiguredMarkupLanguageConfiguration(MarkupLanguageConfiguration markupLanguageConfiguration) {
        if (this.markupLanguageConfiguration != null) {
            throw new BuildException(Messages.getString("MarkupTask.tooManyConfigurations"));
        }
        this.markupLanguageConfiguration = markupLanguageConfiguration;
    }

    public void addConfigured(MarkupLanguageConfiguration markupLanguageConfiguration) {
        this.addConfiguredMarkupLanguageConfiguration(markupLanguageConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readFully(File inputFile) {
        StringBuilder w = new StringBuilder((int)inputFile.length());
        try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(inputFile));
             InputStreamReader r = this.sourceEncoding == null ? new InputStreamReader(input) : new InputStreamReader((InputStream)input, this.sourceEncoding);){
            int i;
            while ((i = ((Reader)r).read()) != -1) {
                w.append((char)i);
            }
        }
        catch (IOException e) {
            throw new BuildException(MessageFormat.format(Messages.getString("MarkupTask.cannotReadSource"), inputFile, e.getMessage()), (Throwable)e);
        }
        return w.toString();
    }
}

