/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.egit.ui.internal.push.PushBranchWizard;
import org.eclipse.egit.ui.internal.push.PushWizardDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.ui.handlers.HandlerUtil;

public class PushCommitHandler
extends AbstractHistoryCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        PlotCommit commit = (PlotCommit)this.getSelection(event).getFirstElement();
        Repository repo = this.getRepository(event);
        try {
            PushBranchWizard wizard = null;
            Ref localBranch = null;
            int i = 0;
            while (i < commit.getRefCount()) {
                Ref currentRef = commit.getRef(i);
                if (localBranch == null && currentRef.getName().startsWith("refs/heads/")) {
                    localBranch = currentRef;
                }
                ++i;
            }
            wizard = localBranch == null ? new PushBranchWizard(repo, commit.getId()) : new PushBranchWizard(repo, localBranch);
            PushWizardDialog dlg = new PushWizardDialog(HandlerUtil.getActiveShellChecked((ExecutionEvent)event), (IWizard)wizard);
            dlg.setHelpAvailable(true);
            dlg.open();
        }
        catch (Exception e) {
            Activator.handleError(e.getMessage(), e, true);
        }
        return null;
    }

    public boolean isEnabled() {
        GitHistoryPage page = this.getPage();
        if (page == null) {
            return false;
        }
        IStructuredSelection sel = this.getSelection(page);
        return sel.size() == 1 && sel.getFirstElement() instanceof RevCommit;
    }
}

