/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.codeactions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.CodeActionFactory;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionRequest;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class src_annotationCodeAction
implements ICodeActionParticipant {
    private static List<String> potentialTags = new ArrayList<String>(){
        {
            this.add("xs:appinfo");
            this.add("xs:documentation");
        }
    };

    @Override
    public void doCodeAction(ICodeActionRequest request, List<CodeAction> codeActions, CancelChecker cancelChecker) {
        Object codeActionText;
        Diagnostic diagnostic = request.getDiagnostic();
        DOMDocument document = request.getDocument();
        Range diagnosticRange = diagnostic.getRange();
        Range closeRange = null;
        try {
            int startOffset = document.offsetAt(diagnosticRange.getStart()) + 1;
            DOMNode node = document.findNodeAt(startOffset);
            DOMElement element = (DOMElement)node;
            String tagName = element.getTagName();
            codeActionText = "Replace '" + tagName + "' with ";
            closeRange = XMLPositionUtility.selectEndTagName(element);
        }
        catch (BadLocationException e) {
            codeActionText = "Replace with ";
        }
        for (String potentialTag : potentialTags) {
            ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
            TextEdit replaceOpen = new TextEdit(diagnosticRange, potentialTag);
            edits.add(replaceOpen);
            if (closeRange != null) {
                TextEdit replaceClose = new TextEdit(closeRange, potentialTag);
                edits.add(replaceClose);
            }
            CodeAction replaceAction = CodeActionFactory.replace((String)codeActionText + "'" + potentialTag + "'", edits, document.getTextDocument(), diagnostic);
            codeActions.add(replaceAction);
        }
    }
}

