/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.property.editor.image.plugin;

import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.AbstractImageDialog;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.AbstractBrowseImagePage;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IImageContainer;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IImageElement;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IImageRoot;
import org.eclipse.wb.internal.swt.Activator;
import org.eclipse.wb.internal.swt.model.ModelMessages;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.FilterConfigurer;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.PluginImagesRoot;

public class PluginFileImagePage
extends AbstractBrowseImagePage {
    public static final String ID = "PLUGIN";
    private final FilterConfigurer m_filterConfigurer;
    private final PaletteTreeFilter m_filter = new PaletteTreeFilter();
    private boolean m_enabledFilter;
    private final Text m_filterText;
    private final ToolItem m_clearButton;
    private final ToolItem m_wButton;
    private final ToolItem m_rButton;
    private final ToolItem m_uiButton;
    private final ToolItem m_allButton;
    private final PluginImagesRoot m_root;
    protected Timer m_uiFilterTimer;

    public static AbstractBrowseImagePage createPage(Composite parent, int style, AbstractImageDialog imageDialog, IProject project) {
        Composite pageComposite = new Composite(parent, style);
        GridLayoutFactory.create((Composite)pageComposite);
        Composite filterBarComposite = new Composite(pageComposite, 0);
        GridDataFactory.create((Control)filterBarComposite).fillH().grabH();
        FilterConfigurer filterConfigurer = new FilterConfigurer(true, true, true, false);
        return new PluginFileImagePage(pageComposite, 0, imageDialog, project, filterBarComposite, filterConfigurer, new PluginImagesRoot(project, filterConfigurer));
    }

    private PluginFileImagePage(Composite parent, int style, AbstractImageDialog imageDialog, IProject project, Composite filterBarComposite, FilterConfigurer filterConfigurer, PluginImagesRoot root) {
        super(parent, style, imageDialog, (IImageRoot)root);
        this.m_root = root;
        GridLayoutFactory.modify((Composite)this).noMargins();
        GridDataFactory.create((Control)this).fill().grab();
        this.m_filterConfigurer = filterConfigurer;
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PluginFileImagePage.this.stopUIFilterTimer();
            }
        });
        GridLayoutFactory.create((Composite)filterBarComposite).columns(3).noMargins();
        this.m_filterText = new Text(filterBarComposite, 2180);
        GridDataFactory.create((Control)this.m_filterText).fillH().grabH();
        this.m_filterText.setText(ModelMessages.PluginFileImagePage_emptyFilterText);
        this.m_filterText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PluginFileImagePage.this.m_filterText.selectAll();
            }
        });
        this.m_filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PluginFileImagePage.this.stopUIFilterTimer();
                PluginFileImagePage.this.m_uiFilterTimer = new Timer();
                PluginFileImagePage.this.m_uiFilterTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                PluginFileImagePage.this.handleModifyFilter();
                            }
                        });
                        (this).PluginFileImagePage.this.m_uiFilterTimer = null;
                    }
                }, 600L);
            }
        });
        ToolBar filterTextToolBar = new ToolBar(filterBarComposite, 0x820000);
        this.m_clearButton = new ToolItem(filterTextToolBar, 8);
        this.m_clearButton.setImage(Activator.getImage("clear_new.gif"));
        this.m_clearButton.setToolTipText(ModelMessages.PluginFileImagePage_clearButton);
        this.m_clearButton.setEnabled(false);
        this.m_clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginFileImagePage.this.m_filterText.setText("");
            }
        });
        ToolBar filterToolBar = new ToolBar(filterBarComposite, 0x820000);
        GridDataFactory.create((Control)filterToolBar).alignHR();
        this.m_wButton = new ToolItem(filterToolBar, 32);
        this.m_wButton.setImage(Activator.getImage("workspace_projects.png"));
        this.m_wButton.setToolTipText(ModelMessages.PluginFileImagePage_showWorkspacePluginsButton);
        this.m_wButton.setSelection(true);
        this.m_wButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginFileImagePage.this.m_filterConfigurer.showWorkspacePlugins(PluginFileImagePage.this.m_wButton.getSelection());
                if (PluginFileImagePage.this.m_filterConfigurer.isDirty()) {
                    PluginFileImagePage.this.refresh();
                }
            }
        });
        this.m_rButton = new ToolItem(filterToolBar, 32);
        this.m_rButton.setImage(Activator.getImage("required_projects.png"));
        this.m_rButton.setToolTipText(ModelMessages.PluginFileImagePage_showRequiredPluginsButton);
        this.m_rButton.setSelection(true);
        this.m_rButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginFileImagePage.this.m_filterConfigurer.showRequiredPlugins(PluginFileImagePage.this.m_rButton.getSelection());
                if (PluginFileImagePage.this.m_filterConfigurer.isDirty()) {
                    PluginFileImagePage.this.refresh();
                }
            }
        });
        new ToolItem(filterToolBar, 2);
        this.m_uiButton = new ToolItem(filterToolBar, 16);
        this.m_uiButton.setImage(Activator.getImage("ui_projects.png"));
        this.m_uiButton.setToolTipText(ModelMessages.PluginFileImagePage_showUiPluginsButton);
        this.m_uiButton.setSelection(true);
        this.m_uiButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginFileImagePage.this.m_filterConfigurer.showUIPlugins(PluginFileImagePage.this.m_uiButton.getSelection());
                if (PluginFileImagePage.this.m_filterConfigurer.isDirty()) {
                    PluginFileImagePage.this.refresh();
                }
            }
        });
        this.m_allButton = new ToolItem(filterToolBar, 16);
        this.m_allButton.setImage(Activator.getImage("all_projects.png"));
        this.m_allButton.setToolTipText(ModelMessages.PluginFileImagePage_showAllPluginsButton);
        this.m_allButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginFileImagePage.this.m_filterConfigurer.showAllPlugins(PluginFileImagePage.this.m_allButton.getSelection());
                if (PluginFileImagePage.this.m_filterConfigurer.isDirty()) {
                    PluginFileImagePage.this.refresh();
                }
            }
        });
    }

    protected final void handleModifyFilter() {
        String filterText = this.m_filterText.getText();
        boolean canEmptyFilterText = filterText.length() == 0;
        this.m_clearButton.setEnabled(!canEmptyFilterText);
        if (this.m_enabledFilter) {
            if (canEmptyFilterText) {
                this.m_enabledFilter = false;
                this.resetFilter();
            } else {
                this.refreshFilter(filterText, false);
            }
        } else if (!canEmptyFilterText) {
            this.m_enabledFilter = true;
            this.refreshFilter(filterText, true);
        }
    }

    private void resetFilter() {
        TreeViewer viewer = this.getViewer();
        try {
            viewer.getControl().setRedraw(false);
            viewer.resetFilters();
            viewer.collapseAll();
        }
        finally {
            viewer.getControl().setRedraw(true);
        }
    }

    private void refreshFilter(String filterText, boolean canAddFilter) {
        TreeViewer viewer = this.getViewer();
        try {
            viewer.getControl().setRedraw(false);
            this.m_filter.setPattern(filterText);
            if (canAddFilter) {
                viewer.addFilter((ViewerFilter)this.m_filter);
            } else {
                viewer.refresh();
            }
            viewer.expandAll();
        }
        finally {
            viewer.getControl().setRedraw(true);
        }
    }

    protected final void stopUIFilterTimer() {
        if (this.m_uiFilterTimer != null) {
            this.m_uiFilterTimer.cancel();
            this.m_uiFilterTimer = null;
        }
    }

    public String getId() {
        return ID;
    }

    public String getTitle() {
        return ModelMessages.PluginFileImagePage_title;
    }

    protected Control getPageControl() {
        return this.getParent();
    }

    public void init(Object data) {
        this.m_root.init(data);
    }

    private static class PaletteTreeFilter
    extends ViewerFilter {
        private SearchPattern m_pattern;

        private PaletteTreeFilter() {
        }

        public void setPattern(String pattern) {
            if (pattern.indexOf(42) == -1) {
                pattern = String.valueOf(pattern) + '*';
            }
            this.m_pattern = new SearchPattern();
            this.m_pattern.setPattern(pattern);
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            IImageElement imageElement = (IImageElement)element;
            if (this.m_pattern.matches(imageElement.getName())) {
                return true;
            }
            if (element instanceof IImageContainer) {
                IImageContainer container = (IImageContainer)element;
                IImageElement[] elements = container.elements();
                ArrayList<IImageContainer> containers = new ArrayList<IImageContainer>();
                IImageElement[] iImageElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IImageElement subElement = iImageElementArray[n2];
                    if (this.m_pattern.matches(subElement.getName())) {
                        return true;
                    }
                    if (subElement instanceof IImageContainer) {
                        containers.add((IImageContainer)subElement);
                    }
                    ++n2;
                }
                for (IImageContainer subContainer : containers) {
                    if (!this.select(viewer, element, subContainer)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

