/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.description;

import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.description.AbstractDescription;
import org.eclipse.wb.internal.core.xml.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.core.xml.model.property.converter.ExpressionConverter;

public final class GenericPropertyDescription
extends AbstractDescription {
    private final String m_id;
    private final String m_name;
    private final String m_title;
    private final Class<?> m_type;
    private PropertyCategory m_category = PropertyCategory.NORMAL;
    private Object m_defaultValue = Property.UNKNOWN_VALUE;
    private final ExpressionAccessor m_accessor;
    private ExpressionConverter m_converter;
    private PropertyEditor m_editor;

    public GenericPropertyDescription(String id, String name, Class<?> type, ExpressionAccessor accessor) {
        this.m_id = id;
        this.m_name = name;
        this.m_title = name;
        this.m_type = type;
        this.m_accessor = accessor;
    }

    public String getId() {
        return this.m_id;
    }

    public String getName() {
        return this.m_name;
    }

    public String getTitle() {
        String title = this.getTag("title");
        if (title != null) {
            return title;
        }
        return this.m_title;
    }

    public Class<?> getType() {
        return this.m_type;
    }

    public void setCategory(PropertyCategory category) {
        this.m_category = category;
    }

    public PropertyCategory getCategory() {
        return this.m_category;
    }

    public Object getDefaultValue() {
        return this.m_defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.m_defaultValue = defaultValue;
    }

    public ExpressionAccessor getAccessor() {
        return this.m_accessor;
    }

    public void setConverter(ExpressionConverter converter) {
        this.m_converter = converter;
    }

    public ExpressionConverter getConverter() {
        return this.m_converter;
    }

    public void setEditor(PropertyEditor editor) {
        this.m_editor = editor;
    }

    public PropertyEditor getEditor() {
        return this.m_editor;
    }

    @Override
    public void visit(XmlObjectInfo object, int state) throws Exception {
        super.visit(object, state);
        this.m_accessor.visit(object, state);
    }
}

