/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.emf;

import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EObjectObservableList;
import org.eclipse.emf.databinding.EObjectObservableMap;
import org.eclipse.emf.databinding.EObjectObservableValue;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xwt.IDataProvider;
import org.eclipse.xwt.IDataProviderFactory;
import org.eclipse.xwt.emf.EMFDataModelService;
import org.eclipse.xwt.emf.EMFDataProvider;

public class EMFDataProviderFactory
implements IDataProviderFactory {
    public static final String EMF_DATA_PROVIDER_FACTORY = "EMF.DataProvider.Factory";

    public IDataProvider create(Object dataContext) {
        if (dataContext instanceof EObject) {
            EMFDataProvider dataProvider = this.createEMFDataProvider();
            dataProvider.setObjectInstance(dataContext);
            return dataProvider;
        }
        if (dataContext instanceof EClassifier) {
            EClassifier classifier = (EClassifier)dataContext;
            EMFDataProvider dataProvider = this.createEMFDataProvider();
            dataProvider.setTypeURI(EcoreUtil.getURI((EObject)classifier));
            return dataProvider;
        }
        if (dataContext instanceof EObjectObservableValue || dataContext instanceof EObjectObservableList || dataContext instanceof EObjectObservableMap) {
            EMFDataProvider dataProvider = this.createEMFDataProvider();
            dataProvider.setObjectInstance(dataContext);
            return dataProvider;
        }
        if (dataContext instanceof Class) {
            Class classType = (Class)dataContext;
            EClassifier classifier = (EClassifier)EMFDataModelService.determineModelType(classType);
            EMFDataProvider dataProvider = this.createEMFDataProvider();
            dataProvider.setTypeURI(EcoreUtil.getURI((EObject)classifier));
            return dataProvider;
        }
        if (dataContext instanceof IObservableValue) {
            Object valueType = ((IObservableValue)dataContext).getValueType();
            if (valueType instanceof EObject) {
                EMFDataProvider dataProvider = this.createEMFDataProvider();
                dataProvider.setObjectInstance(dataContext);
                return dataProvider;
            }
        } else if (dataContext instanceof IObservableList) {
            EMFDataProvider dataProvider = this.createEMFDataProvider();
            dataProvider.setObjectInstance(dataContext);
            return dataProvider;
        }
        return null;
    }

    protected EMFDataProvider createEMFDataProvider() {
        return new EMFDataProvider();
    }

    public Class<?> getType() {
        return EObject.class;
    }
}

