/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.tool.cvspm.Log;
import com.sun.electric.tool.user.dialogs.EDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;

public class CVSLog
extends EDialog
implements MouseListener {
    private JTable jTable1;
    private JScrollPane logTablePane;

    public CVSLog(List<Log.LogEntry> entries, String title, String workingVersion) {
        super((Frame)null, false);
        this.initComponents();
        this.setTitle(title);
        LogTableModel model = new LogTableModel(entries);
        model.workingVersion = workingVersion;
        this.jTable1.setModel(model);
        this.pack();
        this.jTable1.addMouseListener(this);
    }

    public void showContextMenu(MouseEvent e) {
        int[] selectedRows = this.jTable1.getSelectedRows();
        JPopupMenu menu = new JPopupMenu();
        JMenuItem menuCompareLocal = new JMenuItem("Compare with Local");
        menuCompareLocal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CVSLog.this.compareWithLocal();
            }
        });
        menu.add(menuCompareLocal);
        JMenuItem menuCompare = new JMenuItem("Compare Versions");
        menuCompare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CVSLog.this.compare();
            }
        });
        menu.add(menuCompare);
        JMenuItem menuGet = new JMenuItem("Revert to this Version");
        menuGet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CVSLog.this.getVersion();
            }
        });
        menu.add(menuGet);
        menuCompareLocal.setEnabled(false);
        menuCompare.setEnabled(false);
        menuGet.setEnabled(false);
        if (selectedRows.length == 1) {
            menuCompareLocal.setEnabled(true);
            menuGet.setEnabled(true);
        } else if (selectedRows.length == 2) {
            menuCompare.setEnabled(true);
        }
        menu.show((Component)e.getSource(), e.getX(), e.getY());
    }

    private void compareWithLocal() {
        int[] selectedRows = this.jTable1.getSelectedRows();
        if (selectedRows.length != 1) {
            return;
        }
        List<Log.LogEntry> entries = ((LogTableModel)this.jTable1.getModel()).entries;
        Log.compareWithLocal(entries.get(selectedRows[0]));
    }

    private void compare() {
        int[] selectedRows = this.jTable1.getSelectedRows();
        if (selectedRows.length != 2) {
            return;
        }
        List<Log.LogEntry> entries = ((LogTableModel)this.jTable1.getModel()).entries;
        Log.compare(entries.get(selectedRows[0]), entries.get(selectedRows[1]));
    }

    private void getVersion() {
        int[] selectedRows = this.jTable1.getSelectedRows();
        if (selectedRows.length != 1) {
            return;
        }
        List<Log.LogEntry> entries = ((LogTableModel)this.jTable1.getModel()).entries;
        Log.getVersion(entries.get(selectedRows[0]));
        this.setVisible(false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showContextMenu(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    protected void escapePressed() {
        this.setVisible(false);
    }

    private void initComponents() {
        this.logTablePane = new JScrollPane();
        this.jTable1 = new JTable();
        this.getContentPane().setLayout(new GridBagLayout());
        this.logTablePane.setPreferredSize(new Dimension(1000, 203));
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.logTablePane.setViewportView(this.jTable1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.logTablePane, gridBagConstraints);
        this.pack();
    }

    private static class LogTableModel
    extends AbstractTableModel {
        private static final String[] colHeaders = new String[]{"Version", "Branch", "Date", "Author", "Commit Message", "State", "Tag"};
        private String workingVersion = "";
        private List<Log.LogEntry> entries;

        private LogTableModel(List<Log.LogEntry> entries) {
            this.entries = entries;
        }

        @Override
        public int getRowCount() {
            return this.entries.size();
        }

        @Override
        public int getColumnCount() {
            return colHeaders.length;
        }

        @Override
        public String getColumnName(int col) {
            return colHeaders[col];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Log.LogEntry entry = this.entries.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    if (entry.version.equals(this.workingVersion)) {
                        return entry.version + " (current)";
                    }
                    return entry.version;
                }
                case 1: {
                    return entry.branch;
                }
                case 2: {
                    return entry.date;
                }
                case 3: {
                    return entry.author;
                }
                case 4: {
                    return entry.commitMessage;
                }
                case 5: {
                    return entry.state;
                }
                case 6: {
                    return entry.tag;
                }
            }
            return "";
        }
    }
}

