# lint_ignore=E501
config = {
    "shipped-locales-url": "https://hg.mozilla.org/%(repo)s/raw-file/%(revision)s/browser/locales/shipped-locales",
    "products": {
        "installer": {
            "product-name": "IceCat-%(version)s",
            "ssl-only": False,
            "add-locales": True,
            "paths": {
                "linux": {
                    "path": "/icecat/releases/%(version)s/linux-i686/:lang/icecat-%(version)s.tar.bz2",
                    "bouncer-platform": "linux",
                },
                "linux64": {
                    "path": "/icecat/releases/%(version)s/linux-x86_64/:lang/icecat-%(version)s.tar.bz2",
                    "bouncer-platform": "linux64",
                },
                "macosx64": {
                    "path": "/icecat/releases/%(version)s/mac/:lang/IceCat%%20%(version)s.dmg",
                    "bouncer-platform": "osx",
                },
                "win32": {
                    "path": "/icecat/releases/%(version)s/win32/:lang/IceCat%%20Setup%%20%(version)s.exe",
                    "bouncer-platform": "win",
                },
                "win64": {
                    "path": "/icecat/releases/%(version)s/win64/:lang/IceCat%%20Setup%%20%(version)s.exe",
                    "bouncer-platform": "win64",
                },
            },
        },
        "installer-ssl": {
            "product-name": "IceCat-%(version)s-SSL",
            "ssl-only": True,
            "add-locales": True,
            "paths": {
                "linux": {
                    "path": "/icecat/releases/%(version)s/linux-i686/:lang/icecat-%(version)s.tar.bz2",
                    "bouncer-platform": "linux",
                },
                "linux64": {
                    "path": "/icecat/releases/%(version)s/linux-x86_64/:lang/icecat-%(version)s.tar.bz2",
                    "bouncer-platform": "linux64",
                },
                "macosx64": {
                    "path": "/icecat/releases/%(version)s/mac/:lang/IceCat%%20%(version)s.dmg",
                    "bouncer-platform": "osx",
                },
                "win32": {
                    "path": "/icecat/releases/%(version)s/win32/:lang/IceCat%%20Setup%%20%(version)s.exe",
                    "bouncer-platform": "win",
                },
                "win64": {
                    "path": "/icecat/releases/%(version)s/win64/:lang/IceCat%%20Setup%%20%(version)s.exe",
                    "bouncer-platform": "win64",
                },
            },
        },
        "stub-installer": {
            "product-name": "IceCat-%(version)s-stub",
            "ssl-only": True,
            "add-locales": True,
            "paths": {
                "win32": {
                    "path": "/icecat/releases/%(version)s/win32/:lang/IceCat%%20Setup%%20Stub%%20%(version)s.exe",
                    "bouncer-platform": "win",
                },
                "win64": {
                    "path": "/icecat/releases/%(version)s/win64/:lang/IceCat%%20Setup%%20Stub%%20%(version)s.exe",
                    "bouncer-platform": "win64",
                },
            },
        },
        "complete-mar": {
            "product-name": "IceCat-%(version)s-Complete",
            "ssl-only": False,
            "add-locales": True,
            "paths": {
                "linux": {
                    "path": "/icecat/releases/%(version)s/update/linux-i686/:lang/icecat-%(version)s.complete.mar",
                    "bouncer-platform": "linux",
                },
                "linux64": {
                    "path": "/icecat/releases/%(version)s/update/linux-x86_64/:lang/icecat-%(version)s.complete.mar",
                    "bouncer-platform": "linux64",
                },
                "macosx64": {
                    "path": "/icecat/releases/%(version)s/update/mac/:lang/icecat-%(version)s.complete.mar",
                    "bouncer-platform": "osx",
                },
                "win32": {
                    "path": "/icecat/releases/%(version)s/update/win32/:lang/icecat-%(version)s.complete.mar",
                    "bouncer-platform": "win",
                },
                "win64": {
                    "path": "/icecat/releases/%(version)s/update/win64/:lang/icecat-%(version)s.complete.mar",
                    "bouncer-platform": "win64",
                },
            },
        },
    },
    "partials": {
        "releases-dir": {
            "product-name": "IceCat-%(version)s-Partial-%(prev_version)s",
            "ssl-only": False,
            "add-locales": True,
            "paths": {
                "linux": {
                    "path": "/icecat/releases/%(version)s/update/linux-i686/:lang/icecat-%(prev_version)s-%(version)s.partial.mar",
                    "bouncer-platform": "linux",
                },
                "linux64": {
                    "path": "/icecat/releases/%(version)s/update/linux-x86_64/:lang/icecat-%(prev_version)s-%(version)s.partial.mar",
                    "bouncer-platform": "linux64",
                },
                "macosx64": {
                    "path": "/icecat/releases/%(version)s/update/mac/:lang/icecat-%(prev_version)s-%(version)s.partial.mar",
                    "bouncer-platform": "osx",
                },
                "win32": {
                    "path": "/icecat/releases/%(version)s/update/win32/:lang/icecat-%(prev_version)s-%(version)s.partial.mar",
                    "bouncer-platform": "win",
                },
                "win64": {
                    "path": "/icecat/releases/%(version)s/update/win64/:lang/icecat-%(prev_version)s-%(version)s.partial.mar",
                    "bouncer-platform": "win64",
                },
            },
        },
    },
}
