#set -x

function usage
{
  if [[ -n ${flag_debug} ]]
  then
    set -x
  fi

  echo "Usage: unMountForTSM.sh -i [IP Address] -t [taret name] -u [user name] -p [user password] "
  echo "                        -v -h -o [output file] -f [path/configFileName] -D [Domain] -w [path] -U [User] "
  echo ""
  echo "  -i    [Required with -m or -s] IP Address of the ISCSI targets. "
  echo "  -t    [Required with -m] ISCSI target name. "
  echo "  -u    [Required] FastBack User Name to authenticat with Fastback shell with. "
  echo "  -p    [Required] FastBack User Name password to authenticat with Fastback shell with. "
  echo "  -D    [Optional] FastBack Server Domain. Default is \"xpress-restore\". "
  echo "  -w    [Optional] FastBackShell path. Default is \"/c/Program Files/Tivoli/TSM/FastBack/shell\". "
  echo "  -U    [Optional] Windows server User. Default is \"Administrator\". "
  echo "  -o    [Optional] stdout will also go to the filename specified."
  echo "  -f    [Optional] Path and filename of config file. If not set the default config file is used. "
  echo "  -h    [Optional] Display this help. "
  echo "  -v    [Optional] Verbose. "
  echo ""
}

config_commandFile=`whence $0`
config_configFile=`dirname ${config_commandFile}`/configFile

. `dirname ${config_commandFile}`/commonFunctions

loadConfigFile

while getopts dhi:t:f:o:u:p:D:w:U:v c 2> /dev/null
do
  case $c in
    i) config_FBSIPAddr=${OPTARG};;
    t) config_ISCSITargetName=${OPTARG};;
    u) config_FBSUserName=${OPTARG};;
    p) config_FBSUserNamePasswd=${OPTARG};;
    D) config_FBSDomain=${OPTARG};;
    o) config_outputFile=${OPTARG};;
    d) set -x
       flag_debug=true;;
    h) usage
       exit;;
    v) flag_verbose=true;;
    f) config_configFile=${OPTARG}
       loadConfigFile;;
    w) config_FBSDirectory=${OPTARG};;
    U) config_FBSWindowsUser=${OPTARG};;
    *) usage
       exit_print 1;;
  esac
done

if [[ -n ${config_outputFile} ]]
then
  if ! touch ${config_outputFile} > /dev/null 2>&1
  then
    exit_print " Output File ${config_outputFile} is not writable." 24
  fi
fi

if [[ -z ${config_FBSIPAddr} ]]
then
  exit_print_wFile " You must provide a IP address of the FastBackShell Windows server." 20
fi

if [[ -z ${config_ISCSITargetName} ]]
then
  exit_print_wFile " You must provide a ISCSI target." 34
fi

verbose_print "Unmounting ISCSI Target: ${config_ISCSITargetName} from local system"
commandDir=`dirname ${config_commandFile}`
if [[ -n ${config_outputFile} ]]
then
  variableList=" -i ${config_FBSIPAddr} -t ${config_ISCSITargetName} -u -o ${config_outputFile}"
else
  variableList=" -i ${config_FBSIPAddr} -t ${config_ISCSITargetName} -u"
fi

if [[ -n ${flag_debug} ]]
then
  variableList="${variableList} -d"
fi

if [[ -n ${flag_verbose} ]]
then
  variableList="${variableList} -v"
fi

command="${commandDir}/iscsiMount.sh ${variableList} "
verbose_print "Executing Command: ${command}"

${command}
returnCode=$?

if [[ ! ${returnCode} = 0 ]]
then
  exit_print_wFile " Failed to unMount ISCSI target: ${config_ISCSITargetName} from local system" ${returnCode}
fi

verbose_print "Unmounting snapshot from remote FastBack Windows Server"
variableList="-i ${config_FBSIPAddr}"

if [[ -n ${flag_debug} ]]
then
  variableList="${variableList} -d"
fi

if [[ -n ${flag_verbose} ]]
then
  variableList="${variableList} -v"
fi

if [[ ! -z ${config_FBSWindowsUser} ]]
then
  variableList="${variableList} -U ${config_FBSWindowsUser}"
fi

if [[ ! -z ${config_FBSDirectory} ]]
then
  variableList="${variableList} -w ${config_FBSDirectory}"
fi

commandDir=`dirname ${config_commandFile}`
command="${commandDir}/r_FastBackShell.sh ${variableList} -c"

if [[ -n ${config_FBSDomain} ]]
then
  fsbDomain=${config_FBSDomain}
else
  fsbDomain="xpress-restore"
fi

verbose_print "Executing Command: ${command} \"-c -u ${config_FBSUserName} -p ${config_FBSUserNamePasswd} -d ${fsbDomain} set_connection mount_computer ${config_FBSIPAddr} \""
${command} "-c -u ${config_FBSUserName} -p ${config_FBSUserNamePasswd} -d ${fsbDomain} set_connection mount_computer ${config_FBSIPAddr} "

verbose_print "Executing Command: ${command} \"-c -u ${config_FBSUserName} -p ${config_FBSUserNamePasswd} -d ${fsbDomain} mount del -target \"ISCSI:${config_ISCSITargetName}\"\""

if [[ -n ${config_outputFile} ]]
then
  exec 3>&1
  returnCode=`((${command} "-c -u ${config_FBSUserName} -p ${config_FBSUserNamePasswd} -d ${fsbDomain} mount del -target \"ISCSI:${config_ISCSITargetName}\""; echo $? >&4) | tee ${config_outputFile} 1>&3) 4>&1`
else
  ${command} "-c -u ${config_FBSUserName} -p ${config_FBSUserNamePasswd} -d ${fsbDomain} mount del -target \"ISCSI:${config_ISCSITargetName}\""
  returnCode=$?
fi

if [[ ! ${returnCode} = 0 ]]
then
  exit_print_wFile " Unable the unmount snapshot on remote FastBack Server. Command failed " ${returnCode}
fi
