/***********************************************************************
* IBM Storage Protect                                               *
* Common Source Component                                              *
*                                                                      *
* (C) Copyright IBM Corporation 1993,2018                              *
***********************************************************************/

/***********************************************************************
* Header File Name: release.h
*
* Environment:     ************************************************
*                  ** This is a platform-independent source file **
*                  ************************************************
*
* Design Notes:    This file contains the common information about
*                  the actual version.release.level.sublevel
*
* Descriptive-name: Definitions for IBM Storage Protect version
*
* Note: This file should contain no LOG or CMVC information. It is
*       shipped with the API code.
*
*----------------------------------------------------------------------*/

#ifndef _H_RELEASE
#define _H_RELEASE

#define COMMON_VERSION         8
#define COMMON_RELEASE         1
#define COMMON_LEVEL           22
#define COMMON_SUBLEVEL        0
#define COMMON_DRIVER          dsTEXT("")

#define COMMON_VERSIONTXT "8.1.22.0"

#define SHIPYEARTXT  ""
#define SHIPYEARTXTW dsTEXT("2024")
#define TSMPRODTXT  "IBM Storage Protect"

/*======================================================================
   The following string definitions are used for VERSION information
   and should not be converted to dsTEXT or osTEXT.  They are used
   only at link time.

   These are also used when the Jar file is built on Unix.  See the
   the perl script tools/unx/mzbuild/createReleaseJava
======================================================================*/
#define COMMON_VERSION_STR    "8"
#define COMMON_RELEASE_STR    "1"
#define COMMON_LEVEL_STR      "22"
#define COMMON_SUBLEVEL_STR   "0"
#define COMMON_DRIVER_STR     ""

/*=== product names definitions ===*/
#define COMMON_NAME_DFDSM      1
#define COMMON_NAME_ADSM       2
#define COMMON_NAME_TSM        3
#define COMMON_NAME_ITSM       4
#define COMMON_NAME            COMMON_NAME_ITSM

/*======================================================================
   Internal version, release, and level (build) version.  This
   should be unique for every version+release+ptf of a product.
   This information is recorded in the file attributes and data
   stream for diagnostic purposes.
   NOTE: DO NOT MODIFY THESE VALUES. YOU CAN ONLY ADD NEW ENTRIES!
======================================================================*/
#define COMMON_BUILD_TSM_510   1
#define COMMON_BUILD_TSM_511   2
#define COMMON_BUILD_TSM_515   3
#define COMMON_BUILD_TSM_516   4
#define COMMON_BUILD_TSM_520   5
#define COMMON_BUILD_TSM_522   6
#define COMMON_BUILD_TSM_517   7
#define COMMON_BUILD_TSM_523   8
#define COMMON_BUILD_TSM_530   9
#define COMMON_BUILD_TSM_524   10
#define COMMON_BUILD_TSM_532   11
#define COMMON_BUILD_TSM_533   12
#define COMMON_BUILD_TSM_525   13
#define COMMON_BUILD_TSM_534   14
#define COMMON_BUILD_TSM_540   15
#define COMMON_BUILD_TSM_535   16
#define COMMON_BUILD_TSM_541   17
#define COMMON_BUILD_TSM_550   18
#define COMMON_BUILD_TSM_542   19
#define COMMON_BUILD_TSM_551   20
#define COMMON_BUILD_TSM_610   21
#define COMMON_BUILD_TSM_552   22
#define COMMON_BUILD_TSM_611   23
#define COMMON_BUILD_TSM_543   24
#define COMMON_BUILD_TSM_620   25
#define COMMON_BUILD_TSM_612   26
#define COMMON_BUILD_TSM_553   27
#define COMMON_BUILD_TSM_613   28
#define COMMON_BUILD_TSM_621   29
#define COMMON_BUILD_TSM_622   30
#define COMMON_BUILD_TSM_614   31
#define COMMON_BUILD_TSM_623   32
#define COMMON_BUILD_TSM_630   33
#define COMMON_BUILD_TSM_615   34
#define COMMON_BUILD_TSM_624   35
#define COMMON_BUILD_TSM_631   36
#define COMMON_BUILD_TSM_640   37
#define COMMON_BUILD_TSM_710   38
#define COMMON_BUILD_TSM_625   39
#define COMMON_BUILD_TSM_641   40
#define COMMON_BUILD_TSM_711   41
#define COMMON_BUILD_TSM_712   42
#define COMMON_BUILD_TSM_713   43
#define COMMON_BUILD_TSM_714   44
#define COMMON_BUILD_TSM_720   45
#define COMMON_BUILD_TSM_721   46
#define COMMON_BUILD_TSM_642   47
#define COMMON_BUILD_TSM_643   48
#define COMMON_BUILD_TSM_715   49
#define COMMON_BUILD_TSM_716   50
#define COMMON_BUILD_TSM_810   51
#define COMMON_BUILD_TSM_811   52
#define COMMON_BUILD_TSM_812   53
#define COMMON_BUILD_TSM_718   54
#define COMMON_BUILD_TSM_814   55
#define COMMON_BUILD_TSM_816   56
#define COMMON_BUILD_TSM_817   57
#define COMMON_BUILD_TSM_818   58
#define COMMON_BUILD_TSM_819   59
#define COMMON_BUILD_TSM_8110  60
#define COMMON_BUILD_TSM_8111  61
#define COMMON_BUILD_TSM_8112  62
#define COMMON_BUILD_TSM_8113  63
#define COMMON_BUILD_TSM_8114  64
#define COMMON_BUILD_TSM_8115  65
#define COMMON_BUILD_TSM_8117  66
#define COMMON_BUILD_TSM_8119  67
#define COMMON_BUILD_TSM_8120  68
#define COMMON_BUILD_TSM_8121  69
#define COMMON_BUILD_TSM_8122  70
#define COMMON_BUILD           COMMON_BUILD_TSM_8120

/*=== define VRL as an Int for bitmap version compares ====*/
static const  int  VRL_712 = 712;
static const  int  VRL_713 = 713;
static const  int  VRL_714 = 714;
static const  int  VRL_715 = 715;
static const  int  VRL_716 = 716;
static const  int  VRL_718 = 718;
static const  int  VRL_810 = 810;
static const  int  VRL_811 = 811;
static const  int  VRL_812 = 812;
static const  int  VRL_814 = 814;
static const  int  VRL_816 = 816;
static const  int  VRL_817 = 817;
static const  int  VRL_818 = 818;
static const  int  VRL_819 = 819;
static const  int  VRL_8110 = 8110;
static const  int  VRL_8111 = 8111;
static const  int  VRL_8112 = 8112;
static const  int  VRL_8113 = 8113;
static const  int  VRL_8114 = 8114;
static const  int  VRL_8115 = 8115;
static const  int  VRL_8117 = 8117;
static const  int  VRL_8119 = 8119;
static const  int  VRL_8120 = 8120;
static const  int  VRL_8121 = 8121;
static const  int  VRL_8122 = 8122;

#define   TDP4VE_PLATFORM_STRING_MBCS     "TDP VMware"
#define   TDP4VE_PLATFORM_STRING          dsTEXT("TDP VMware")

#define   TDP4HYPERV_PLATFORM_STRING_MBCS "TDP HyperV"
#define   TDP4HYPERV_PLATFORM_STRING      dsTEXT("TDP HyperV")

#endif /* _H_RELEASE */
