##############################################################################
#desc:       This perl script will add filesystem names to
#            JournaledFileSystems statement in tsmjbbd.ini.
#            It can be used in a cluster start script.
#parameters: filesystem names to be added
#example:    perl jbbadd.pl /svt1 /svt2 
###############################################################################

if (-e "/usr/tivoli/tsm/client/ba/bin64/tsmjbbd") {
   $ini_file = "/usr/tivoli/tsm/client/ba/bin64/tsmjbbd.ini";
}
else {
   if (-e "/opt/tivoli/tsm/client/ba/bin/tsmjbbd") {
      $ini_file = "/opt/tivoli/tsm/client/ba/bin/tsmjbbd.ini";
   }
   else {
     die "Can't identify the location of ini file\n";
   }
}

#Check for at least one name
@ARGV > 0 or exit;

# Read the .ini file
open(FILEHANDLE, $ini_file) or die "Unable to open $ini_file\n";
@content = <FILEHANDLE>;
close FILEHANDLE;

# Find the line with the file systems
foreach $line (@content) {
   if($line =~ /JournaledFileSystems=/){

# Make sure it is not a comment 
      @temp = split /\s*JournaledFileSystems=/,$line, 2;
      if ($temp[0] eq "") {
# Substitute space for newline character
         $line =~ s/\n$/ /;

# Add if if it is not there
         foreach $fs (@ARGV) {
            if (!($line =~ m@=$fs\s|\s$fs\s@)) {
               $line .=  $fs . " ";
            }
         }

# Remove the extra blank and add a newline char
         chop $line;
         $line .= "\n";     
         last;
      }
   }
}

# Now write the file
open(FILEWRITE, ">$ini_file");
print FILEWRITE @content;
close FILEWRITE; 


# If the journal daemon is not runing yet then start it
$output = `ps -ae|grep tsmjbbd`;
chomp($output);
if ($output eq ""){
   print ("Starting journal\n");
   `/usr/bin/tsmjbbd`;
}

