/* $Id: lightness.c,v 1.4 2005/05/21 22:42:22 cegger Exp $
******************************************************************************

   Generic color default library implementation

   Copyright (C) 2000-2001 Christoph Egger	[Christoph_Egger@t-online.de]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/


#include <stdlib.h>

#include "config.h"
#include "color.h"



/* Lightness manipulation
 */

gcp_pixel GGI_color_SetIntensity(ggi_visual_t vis,
			const gcp_pixel *pix1, const gcp_pixel *light_color)
{
	int rc;
	gcp_RGBAcolor base_col;
	gcp_RGBAcolor light_col;
	gcp_RGBAcolor dst_col;

	rc = gcpUnmapRGBAPixel(vis, *pix1, &base_col);
	LIB_ASSERT(rc == 0, "gcpUnmapRGBAPixel(vis, pix1, base_col) failed");
	rc = gcpUnmapRGBAPixel(vis, *light_color, &light_col);
	LIB_ASSERT(rc == 0, "gcpUnmapRGBAPixel(vis, light_color, light_col) failed");


	dst_col.r = (base_col.r * light_col.r) / 0xFFFF;
	dst_col.g = (base_col.g * light_col.g) / 0xFFFF;
	dst_col.b = (base_col.b * light_col.b) / 0xFFFF;
	dst_col.a = (base_col.a * light_col.a) / 0xFFFF;

	return gcpMapRGBAColor(vis, &dst_col);
}	/* GGI_color_SetIntensity */


gcp_pixel GGI_color_GetIntensity(ggi_visual_t vis,
			const gcp_pixel *pix1, const gcp_pixel *pix2)
{
	int rc;
	gcp_RGBAcolor base_col;
	gcp_RGBAcolor light_col;
	gcp_RGBAcolor dst_col;

	rc = gcpUnmapRGBAPixel(vis, *pix1, &base_col);
	LIB_ASSERT(rc == 0, "gcpUnmapRGBAPixel(vis, pix1, base_col) failed");
	rc = gcpUnmapRGBAPixel(vis, *pix2, &dst_col);
	LIB_ASSERT(rc == 0, "gcpUnmapRGBAPixel(vis, pix2, dst_col) failed");


	light_col.r = abs(dst_col.r - base_col.r);
	light_col.g = abs(dst_col.g - base_col.g);
	light_col.b = abs(dst_col.b - base_col.b);


	return gcpMapRGBAColor(vis, &light_col);
}	/* GGI_color_GetIntensity */
