/* $Id: move.c,v 1.8 2005/09/05 10:45:48 pekberg Exp $
******************************************************************************

   Graphics library for GGI. WMH stuff.

   Copyright (C) 2004 Peter Ekberg	[peda@lysator.liu.se]
   Copyright (C) 1998 Andreas Beck	[becka@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "config.h"
#include "directxwmh.h"

int GGIwmh_directx_move(ggi_visual *vis,int x,int y)
{
	directx_priv *priv;                                                   
	RECT r1, r2;
	int width, height;
	DWORD ws_flags = WS_OVERLAPPEDWINDOW & ~WS_MAXIMIZEBOX;
	priv=LIBGGI_PRIVATE(vis);

	if (priv->fullscreen)
		return GGI_ENOMATCH;

	GGI_directx_Lock(priv->cs);
	GetWindowRect(priv->hWnd, &r1);
	r2 = r1;
	AdjustWindowRectEx(&r2, ws_flags, FALSE, 0);
	width    = r1.right  - r1.left;
	height   = r1.bottom - r1.top;
	if(x < 0) x = 0;
	if(y < 0) y = 0;
	x -= r1.left - r2.left;
	y -= r1.top  - r2.top;
	MoveWindow(priv->hWnd, x, y, width, height, TRUE);
	GGI_directx_Unlock(priv->cs);

	return 0;
}

static int _ggiwmh_getgeometry(ggi_visual *vis,int *x,int *y,int *w,int *h) {

	directx_priv *priv;
	RECT r1, r2;
	DWORD ws_flags = WS_OVERLAPPEDWINDOW & ~WS_MAXIMIZEBOX;
	priv=LIBGGI_PRIVATE(vis);

	GGI_directx_Lock(priv->cs);
	GetWindowRect(priv->hWnd, &r1);
	r2 = r1;
	AdjustWindowRectEx(&r2, ws_flags, FALSE, 0);
	GGI_directx_Unlock(priv->cs);
	if (x) *x= 2 * r1.left   - r2.left;
	if (y) *y= 2 * r1.top    - r2.top;
	if (w) *w=(2 * r1.right  - r2.right)  - (2 * r1.left - r2.left);
	if (h) *h=(2 * r1.bottom - r2.bottom) - (2 * r1.top  - r2.top);
	return 0;
}

int GGIwmh_directx_getpos(ggi_visual *vis,int *x,int *y)
{
	return _ggiwmh_getgeometry(vis,x,y,NULL,NULL);
}

int GGIwmh_directx_getsize(ggi_visual *vis,int *x,int *y)
{
	return _ggiwmh_getgeometry(vis,NULL,NULL,x,y);
}

int GGIwmh_directx_resize(ggi_visual *vis,int x,int y)
{
	directx_priv *priv;
	RECT r1, r2;
	DWORD ws_flags = WS_OVERLAPPEDWINDOW & ~WS_MAXIMIZEBOX;
	priv=LIBGGI_PRIVATE(vis);

	if (priv->fullscreen)
		return GGI_ENOMATCH;

	GGI_directx_Lock(priv->cs);
	GetWindowRect(priv->hWnd, &r1);
	r2 = r1;
	AdjustWindowRectEx(&r2, ws_flags, FALSE, 0);
	MoveWindow(priv->hWnd, r1.left, r1.top,
	           x + (r2.right - r2.left) - (r1.right - r1.left),
	           y + (r2.bottom - r2.top) - (r1.bottom - r1.top),
	           TRUE);
	GGI_directx_Unlock(priv->cs);

	return 0;
}

int GGIwmh_directx_allowresize(ggi_visual *vis, int xmin, int ymin,
			 int xmax, int ymax, int xstep, int ystep)
{
	directx_priv *priv;
	priv=LIBGGI_PRIVATE(vis);

	if (priv->fullscreen)
		return GGI_ENOMATCH;

	if (xmin<0  || ymin<0  || xstep<1 || ystep<1 || 
	    xmin>xmax || ymin>ymax ) return GGI_ENOSPACE;

	GGI_directx_Lock(priv->cs);
	GGI_directx_Lock(priv->sizingcs);
	priv->xmin = xmin;
	priv->ymin = ymin;
	priv->xmax = xmax;
	priv->ymax = ymax;
	priv->xstep = xstep;
	priv->ystep = ystep;
	GGI_directx_Unlock(priv->sizingcs);
	GGI_directx_Unlock(priv->cs);

	return 0;
}

int GGIwmh_directx_maximize(ggi_visual *vis,int x,int y)
{
	directx_priv *priv;
	RECT r;
	priv=LIBGGI_PRIVATE(vis);

	if (priv->fullscreen)
		return GGI_ENOMATCH;

	SystemParametersInfo(SPI_GETWORKAREA, 0, &r, 0);
	GGIwmh_directx_resize(vis,
		x * (r.right - r.left) / 100,
		y * (r.bottom - r.top) / 100);
	return 0;
}

int GGIwmh_directx_moveicon(ggi_visual *vis,int x,int y)
{
	return GGI_ENOFUNC;
}
