/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v2;

import java.util.Vector;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Parser;
import org.postgresql.core.ProtocolConnection;
import org.postgresql.core.Query;
import org.postgresql.core.v2.SimpleParameterList;

class V2Query
implements Query {
    private static final ParameterList NO_PARAMETERS = new SimpleParameterList(0, false);
    private final String[] fragments;
    private final boolean useEStringSyntax;

    V2Query(String query, boolean withParameters, ProtocolConnection pconn) {
        this.useEStringSyntax = pconn.getServerVersion() != null && pconn.getServerVersion().compareTo("8.1") > 0;
        boolean stdStrings = pconn.getStandardConformingStrings();
        if (!withParameters) {
            this.fragments = new String[]{query};
            return;
        }
        Vector<String> v = new Vector<String>();
        int lastParmEnd = 0;
        char[] aChars = query.toCharArray();
        int i = 0;
        while (i < aChars.length) {
            switch (aChars[i]) {
                case '\'': {
                    i = Parser.parseSingleQuotes(aChars, i, stdStrings);
                    break;
                }
                case '\"': {
                    i = Parser.parseDoubleQuotes(aChars, i);
                    break;
                }
                case '-': {
                    i = Parser.parseLineComment(aChars, i);
                    break;
                }
                case '/': {
                    i = Parser.parseBlockComment(aChars, i);
                    break;
                }
                case '$': {
                    i = Parser.parseDollarQuotes(aChars, i);
                    break;
                }
                case '?': {
                    v.addElement(query.substring(lastParmEnd, i));
                    lastParmEnd = i + 1;
                    break;
                }
            }
            ++i;
        }
        v.addElement(query.substring(lastParmEnd, query.length()));
        this.fragments = new String[v.size()];
        int i2 = 0;
        while (i2 < this.fragments.length) {
            this.fragments[i2] = (String)v.elementAt(i2);
            ++i2;
        }
    }

    public void close() {
    }

    public ParameterList createParameterList() {
        if (this.fragments.length == 1) {
            return NO_PARAMETERS;
        }
        return new SimpleParameterList(this.fragments.length - 1, this.useEStringSyntax);
    }

    String[] getFragments() {
        return this.fragments;
    }

    public String toString(ParameterList parameters) {
        StringBuffer sbuf = new StringBuffer(this.fragments[0]);
        int i = 1;
        while (i < this.fragments.length) {
            if (parameters == null) {
                sbuf.append("?");
            } else {
                sbuf.append(parameters.toString(i));
            }
            sbuf.append(this.fragments[i]);
            ++i;
        }
        return sbuf.toString();
    }
}

