# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=libxml2
VER=2.6.32
REV=1
ARCH=win64

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${THIS}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

# I on purpose don't pass any pointers to the headers of either GNU
# libiconv or win-iconv because I don't want libxml2 API to require
# <iconv.h> and use iconv_t, as I can't know which implementation of
# iconv various code that uses libxml2 will use anyway. I wonder if
# this makes sense?  WIN_ICONV=`latest --arch=${ARCH} win-iconv`

ZLIB=`latest --arch=${ARCH} zlib`

usedev
usemingw64
usemsvs9x64

(

set -x

# Avoid the silly "relink" stuff in libtool
sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

patch -p0 <<'EOF' &&
--- ltmain.sh
+++ ltmain.sh
@@ -2559,7 +2559,7 @@
     ;;
   *ar\ archive*) # could be an import, or static
     if eval $OBJDUMP -f $1 | $SED -e '10q' 2>/dev/null | \
-      $EGREP -e 'file format pe-i386(.*architecture: i386)?' >/dev/null ; then
+      $EGREP -e 'file format pe-(.*architecture: i386)?' >/dev/null ; then
       win32_nmres=`eval $NM -f posix -A $1 | \
 	$SED -n -e '1,100{
 		/ I /{
--- configure
+++ configure
@@ -5447,7 +5447,7 @@
     lt_cv_deplibs_check_method='file_magic ^x86 archive import|^x86 DLL'
     lt_cv_file_magic_cmd='func_win32_libid'
   else
-    lt_cv_deplibs_check_method='file_magic file format pei*-i386(.*architecture: i386)?'
+    lt_cv_deplibs_check_method='file_magic file format pei*-(.*architecture: i386)?'
     lt_cv_file_magic_cmd='$OBJDUMP -f'
   fi
   ;;
EOF

CC='x86_64-pc-mingw32-gcc' \
LDFLAGS="-Wl,--enable-auto-image-base" \
CFLAGS=-O2 \
./configure --host=x86_64-pc-mingw32 \--disable-static \
--with-zlib=/devel/dist/${ARCH}/${ZLIB} \
--prefix=$TARGET &&
make -j4 install &&

(cd /devel/target/$HEX &&

zip /tmp/$RUNZIP bin/libxml2-2.dll &&

(echo EXPORTS
link -dump -exports bin/libxml2-2.dll | grep -E '^ *[1-9][0-9]* *[0-9A-F][0-9A-F]* [0-9A-F][0-9A-F][0-9A-F][0-9A-F][0-9A-F][0-9A-F][0-9A-F][0-9A-F] ' | sed -e 's/^ *[^ ][^ ]* *[^ ][^ ]* ........ //' -e 's/ =.*//') >lib/libxml2.def &&
lib -machine:X64 -def:lib/libxml2.def -name:libxml2-2.dll -out:lib/libxml2.lib &&

# Leave out xml2-config, the .pc file is better
zip /tmp/$DEVZIP bin/*.exe &&
zip -r -D /tmp/$DEVZIP include &&
zip /tmp/$DEVZIP lib/libxml2.{def,lib,dll.a} &&
zip /tmp/$DEVZIP lib/pkgconfig/libxml-2.0.pc &&
zip -r -D /tmp/$DEVZIP share

)

) 2>&1 | tee /devel/src/tml/packaging/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/packaging/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
