//
// Author: 
//   Mikael Hallendal <micke@imendio.com>
//
// (C) 2004 Imendio HB
// 

using Gtk;
using System;
using System.IO;
using System.Net;

namespace Imendio.Blam {

    public class Cache {
	private string cacheDirectory;
	
	public Cache(string dataDirectory)
	{
	    cacheDirectory = dataDirectory + "/Cache";
	    if (!File.Exists(cacheDirectory)) {
		Directory.CreateDirectory(cacheDirectory);
	    }
	}

	public Stream GetCachedData(string uri)
	{
	    try {
		string fileName = GenerateCacheName(uri);
		string fullPath = FullPath(fileName);
		return (Stream)File.OpenRead(FullPath(fileName));
	    }
	    catch (Exception e) {
		return null;
	    }
	}

	public void AddCacheData(string uri, string itemId, byte[] data)
	{
	    string fileName = GenerateCacheName(uri);
	    string fullPath = FullPath(fileName);
	   
	    try {
		if (File.Exists(fullPath)) {
		    File.Delete(fullPath);
		}

		FileStream fs = new FileStream(fullPath, FileMode.CreateNew);
		BinaryWriter writer = new BinaryWriter(fs);
		writer.Write(data);
		writer.Close();

	//	if (Database.Db.GetCacheFile(uri) == null) {
	//	    Database.Db.AddCacheFile(uri, itemId, fileName);
	//	}
	    }
	    catch (Exception e) { }
	}

	// Called from DB when removing an item
	public void RemoveData(string fileName)
	{
	    try {
		File.Delete(FullPath(fileName));
	    } 
	    catch (Exception e) { }
	}

	private string FullPath(string fileName)
	{
	    return cacheDirectory + "/" + fileName;
	}

	private string GenerateCacheName(string uri)
	{
	    return uri.GetHashCode().ToString();
	}
    }
}
