// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_STAGE_H
#define _CLUTTERMM_STAGE_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <cluttermm/group.h>
#include <cluttermm/color.h>
#include <clutter/clutter.h> // For ClutterPerspective
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterStage ClutterStage;
typedef struct _ClutterStageClass ClutterStageClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Stage_Class; } // namespace Clutter
namespace Clutter
{

typedef ClutterFog Fog;

class Perspective
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Perspective CppObjectType;
  typedef ClutterPerspective BaseObjectType;

  static GType get_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  Perspective();

  explicit Perspective(const ClutterPerspective* gobject); // always takes a copy

  ///Provides access to the underlying C instance.
  ClutterPerspective*       gobj()       { return &gobject_; }

  ///Provides access to the underlying C instance.
  const ClutterPerspective* gobj() const { return &gobject_; }

protected:
  ClutterPerspective gobject_;

private:
  
public:
  Perspective(Cogl::Fixed fovy, Cogl::Fixed aspect, Cogl::Fixed z_near, Cogl::Fixed z_far);

   Cogl::Fixed get_fovy() const;
    void set_fovy(const Cogl::Fixed& value);
    Cogl::Fixed get_aspect() const;
    void set_aspect(const Cogl::Fixed& value);
    Cogl::Fixed get_z_near() const;
    void set_z_near(const Cogl::Fixed& value);
    Cogl::Fixed get_z_far() const;
    void set_z_far(const Cogl::Fixed& value);
 

};


class Stage :
  public Group
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Stage CppObjectType;
  typedef Stage_Class CppClassType;
  typedef ClutterStage BaseObjectType;
  typedef ClutterStageClass BaseClassType;

private:  friend class Stage_Class;
  static CppClassType stage_class_;

private:
  // noncopyable
  Stage(const Stage&);
  Stage& operator=(const Stage&);

protected:
  explicit Stage(const Glib::ConstructParams& construct_params);
  explicit Stage(ClutterStage* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Stage();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterStage*       gobj()       { return reinterpret_cast<ClutterStage*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterStage* gobj() const { return reinterpret_cast<ClutterStage*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterStage* gobj_copy();

private:


protected:
  Stage();

public:
 

  static Glib::RefPtr<Stage> get_default();
  
  void set_color(const Color& color);
  

  Color get_color() const;

 
  void set_perspective(const Perspective& prespective);
  
  void get_perspective(Perspective& prespective);
  
  void fullscreen();
  
  void unfullscreen();
  
  void show_cursor();
  
  void hide_cursor();
  
  Glib::ustring get_title() const;
  
  void set_title(const Glib::ustring& title);
  
  /** Sets if the stage is resizable by user interaction (e.g.\ via
   * window manager controls)
   * 
   * Since: 0.4
   * @param resizable Whether the stage should be user resizable.
   */
  void set_user_resizable(bool value);
  
  bool get_user_resizable() const;

  
  /** Checks the scene at the coordinates @a x and @a y and returns a pointer
   * to the Clutter::Actor at those coordinates.
   * @param x X coordinate to check.
   * @param y Y coordinate to check.
   * @return (transfer none): the actor at the specified coordinates, if any.
   */
  Glib::RefPtr<Actor> get_actor_at_pos(int x, int y);
  
  /** Checks the scene at the coordinates @a x and @a y and returns a pointer
   * to the Clutter::Actor at those coordinates.
   * @param x X coordinate to check.
   * @param y Y coordinate to check.
   * @return (transfer none): the actor at the specified coordinates, if any.
   */
  Glib::RefPtr<const Actor> get_actor_at_pos(int x, int y) const;

  
  Glib::RefPtr<Actor> get_key_focus();
  
  Glib::RefPtr<const Actor> get_key_focus() const;

  
  void set_key_focus(const Glib::RefPtr<Actor>& actor);
  void set_key_focus();

  // TODO: Should we rather wrap this as std::string, or
  // as std::vector<unsigned char>, or Glib::ArrayHandle<guchar>?
  
  guchar* read_pixels(int x, int y, int width, int height) const;
  
  /** Gets whether the depth cueing effect is enabled on @a stage.
   * @return <tt>true</tt> if the the depth cueing effect is enabled
   * 
   * Since: 0.6.
   */
  bool get_use_fog() const;
  
  void set_use_fog(bool fog = true);
 

  void set_fog(const Fog& fog);
  
  void get_fog(Fog& fog) const;
  
  
  void stage_event(Event* event);
  
  bool is_default() const;
  
  void ensure_current();
  
  void ensure_viewport();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%fullscreen()</tt>
   */

  Glib::SignalProxy0< void > signal_fullscreen();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%unfullscreen()</tt>
   */

  Glib::SignalProxy0< void > signal_unfullscreen();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%activate()</tt>
   */

  Glib::SignalProxy0< void > signal_activate();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%deactivate()</tt>
   */

  Glib::SignalProxy0< void > signal_deactivate();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The color of the stage.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Color> property_color() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The color of the stage.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Color> property_color() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the mouse pointer is visible on the main stage .
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_cursor_visible() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the mouse pointer is visible on the main stage .
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_cursor_visible() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the main stage is fullscreen.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_fullscreen() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the main stage is fullscreen.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_fullscreen() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the main stage is renderer offscreen.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_offscreen() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the main stage is renderer offscreen.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_offscreen() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Stage Title.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_title() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Stage Title.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_title() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to enable depth cueing.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_use_fog() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to enable depth cueing.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_use_fog() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the stage is able to be resized via user interaction.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_user_resizable() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the stage is able to be resized via user interaction.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_user_resizable() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


protected:
  // From the Clutter Docs:
  // Applications should call clutter_actor_queue_redraw and not this function.
  //_WRAP_METHOD(void queue_redraw(), clutter_stage_queue_redraw)
  

public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_fullscreen();
  virtual void on_unfullscreen();
  virtual void on_activate();
  virtual void on_deactivate();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Clutter

//vim: ts=2,sw=2


namespace Glib
{

/** @relates Clutter::Perspective
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
Clutter::Perspective& wrap(ClutterPerspective* object);

/** @relates Clutter::Perspective
 * @param object The C instance
 * @result A C++ instance that wraps this C instance.
 */
const Clutter::Perspective& wrap(const ClutterPerspective* object);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Clutter::Perspective> : public Glib::Value_Boxed<Clutter::Perspective>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Stage
   */
  Glib::RefPtr<Clutter::Stage> wrap(ClutterStage* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_STAGE_H */

