// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_BEHAVIOUR_H
#define _CLUTTERMM_BEHAVIOUR_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <cluttermm/alpha.h>
#include <cluttermm/actor.h>
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterBehaviour ClutterBehaviour;
typedef struct _ClutterBehaviourClass ClutterBehaviourClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Behaviour_Class; } // namespace Clutter
namespace Clutter
{


class Behaviour : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Behaviour CppObjectType;
  typedef Behaviour_Class CppClassType;
  typedef ClutterBehaviour BaseObjectType;
  typedef ClutterBehaviourClass BaseClassType;

private:  friend class Behaviour_Class;
  static CppClassType behaviour_class_;

private:
  // noncopyable
  Behaviour(const Behaviour&);
  Behaviour& operator=(const Behaviour&);

protected:
  explicit Behaviour(const Glib::ConstructParams& construct_params);
  explicit Behaviour(ClutterBehaviour* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Behaviour();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterBehaviour*       gobj()       { return reinterpret_cast<ClutterBehaviour*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterBehaviour* gobj() const { return reinterpret_cast<ClutterBehaviour*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterBehaviour* gobj_copy();

private:


protected:
  Behaviour();

public:
  //There is no create() because this is an abstract base class.
  //_WRAP_CREATE()

  
  /** Applies @a behave to @a actor.  This function adds a reference on
   * the actor.
   * 
   * @newin{0,2}
   * @param actor A Clutter::Actor.
   */
  void apply(const Glib::RefPtr<Actor>& actor);
  
  /** Removes @a actor from the list of Clutter::Actor<!-- -->s to which
   *  @a behave applies.  This function removes a reference on the actor.
   * 
   * @newin{0,2}
   * @param actor A Clutter::Actor.
   */
  void remove(const Glib::RefPtr<Actor>& actor);
  
  /** Removes every actor from the list that @a behave holds.
   * 
   * @newin{0,4}
   */
  void remove_all();
  
  /** Check if @a behave applied to  @a actor.
   * @param actor A Clutter::Actor.
   * @return <tt>true</tt> if actor has behaviour. <tt>false</tt> otherwise.
   * 
   * @newin{0,4}.
   */
  bool is_applied(const Glib::RefPtr<Actor>& actor);

 
  /** Retrieves all the actors to which @a behave applies. It is not recommended
   * for derived classes to use this in there alpha notify method but use 
   * #clutter_behaviour_actors_foreach as it avoids alot of needless allocations.
   * @return (transfer container) (element-type ClutterActor): a list of actors.
   * You should free the returned list with Glib::slist_free() when finished using it.
   * 
   * @newin{0,2}.
   */
  Glib::SListHandle<Glib::RefPtr<Actor> > get_actors();
  
  /** Retrieves all the actors to which @a behave applies. It is not recommended
   * for derived classes to use this in there alpha notify method but use 
   * #clutter_behaviour_actors_foreach as it avoids alot of needless allocations.
   * @return (transfer container) (element-type ClutterActor): a list of actors.
   * You should free the returned list with Glib::slist_free() when finished using it.
   * 
   * @newin{0,2}.
   */
  Glib::SListHandle<Glib::RefPtr<const Actor> > get_actors() const;

  
  /** Gets the number of actors this behaviour is applied too.
   * @return The number of applied actors 
   * 
   * @newin{0,2}.
   */
  int get_n_actors() const;

  
  /** Gets an actor the behaviour was applied to referenced by index num.
   * @param index The index of an actor this behaviour is applied too.
   * @return (transfer none): A Clutter actor or <tt>0</tt> if @a index is invalid.
   * 
   * @newin{0,2}.
   */
  Glib::RefPtr<Actor> get_nth_actor(int index);
  
  /** Gets an actor the behaviour was applied to referenced by index num.
   * @param index The index of an actor this behaviour is applied too.
   * @return (transfer none): A Clutter actor or <tt>0</tt> if @a index is invalid.
   * 
   * @newin{0,2}.
   */
  Glib::RefPtr<const Actor> get_nth_actor(int index) const;

  
  /** Retrieves the Clutter::Alpha object bound to @a behave.
   * @return (transfer none): a Clutter::Alpha object, or <tt>0</tt> if no alpha
   * object has been bound to this behaviour.
   * 
   * @newin{0,2}.
   */
  Glib::RefPtr<Alpha> get_alpha();
  
  /** Retrieves the Clutter::Alpha object bound to @a behave.
   * @return (transfer none): a Clutter::Alpha object, or <tt>0</tt> if no alpha
   * object has been bound to this behaviour.
   * 
   * @newin{0,2}.
   */
  Glib::RefPtr<const Alpha> get_alpha() const;

  
  /** Binds @a alpha to a Clutter::Behaviour. The Clutter::Alpha object
   * is what makes a behaviour work: for each tick of the timeline
   * used by Clutter::Alpha a new value of the alpha parameter is
   * computed by the alpha function; the value should be used by
   * the Clutter::Behaviour to update one or more properties of the
   * actors to which the behaviour applies.
   * 
   * If @a alpha is not <tt>0</tt>, the Clutter::Behaviour will take ownership
   * of the Clutter::Alpha instance.
   * 
   * @newin{0,2}
   * @param alpha A Clutter::Alpha or <tt>0</tt> to unset a previously set alpha.
   */
  void set_alpha(const Glib::RefPtr<Alpha>& alpha);

  // TODO: does this need the 'behaviour' argument, or could that be
  // approximated with an Object-oriented 'this' pointer?
  /** For instance, 
   * void on_foreach(const Glib::RefPtr<Behaviour>& behaviour, const Glib::RefPtr<Actor>& actor)
   */
  typedef sigc::slot<void, const Glib::RefPtr<Behaviour>&, const Glib::RefPtr<Actor>&> SlotForEach;

  void actors_foreach(const SlotForEach& slot);
  

  /**
   * @par Prototype:
   * <tt>void on_my_%applied(const Glib::RefPtr<Actor>& actor)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Actor>& > signal_applied();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%removed(const Glib::RefPtr<Actor>& actor)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Actor>& > signal_removed();


protected:
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void alpha_notify_vfunc(double alpha_value);
#endif //GLIBMM_VFUNCS_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_applied(const Glib::RefPtr<Actor>& actor);
  virtual void on_removed(const Glib::RefPtr<Actor>& actor);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Clutter
// vim:ts=2,sw=2


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Behaviour
   */
  Glib::RefPtr<Clutter::Behaviour> wrap(ClutterBehaviour* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_BEHAVIOUR_H */

